/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.fasterxml.jackson.annotation.JsonInclude;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.PasswordParameterDefinition;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import java.util.HashMap;
import java.util.Map;

public class InputParameterDefExt {
    private final String type;
    private final String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String description;
    private final Map<String, Object> definition;

    public InputParameterDefExt(@NonNull ParameterDefinition definition) {
        this.type = definition.getType();
        this.name = definition.getName();
        this.description = definition.getDescription();
        this.definition = InputParameterDefExt.toDefinitionMap(definition);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getDefinition() {
        return this.definition;
    }

    static Map<String, Object> toDefinitionMap(@NonNull ParameterDefinition definition) {
        HashMap<String, Object> definitionMap = new HashMap<String, Object>();
        if (definition instanceof BooleanParameterDefinition) {
            definitionMap.put("defaultVal", ((BooleanParameterDefinition)definition).isDefaultValue());
        } else if (definition instanceof StringParameterDefinition) {
            definitionMap.put("defaultVal", ((StringParameterDefinition)definition).getDefaultValue());
        } else if (definition instanceof PasswordParameterDefinition) {
            definitionMap.put("defaultVal", ((PasswordParameterDefinition)definition).getDefaultValue());
        } else if (definition instanceof ChoiceParameterDefinition) {
            StringParameterValue defaultParameterValue = ((ChoiceParameterDefinition)definition).getDefaultParameterValue();
            if (defaultParameterValue != null) {
                definitionMap.put("defaultVal", defaultParameterValue.getValue());
            }
            definitionMap.put("choices", ((ChoiceParameterDefinition)definition).getChoices());
        }
        return definitionMap;
    }
}

