/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.rest.external.StatusExt;
import com.cloudbees.workflow.util.ModelUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class FlowNodeLogExt {
    private static long MAX_RETURN_CHARS = Integer.getInteger(FlowNodeLogExt.class.getName() + ".maxReturnChars", 10240).intValue();
    private static final Logger LOGGER = Logger.getLogger(FlowNodeLogExt.class.getName());
    private String nodeId;
    private StatusExt nodeStatus;
    private long length = 0L;
    private boolean hasMore = false;
    private String text;
    private String consoleUrl;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public StatusExt getNodeStatus() {
        return this.nodeStatus;
    }

    public void setNodeStatus(StatusExt nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We're not writing to a file")
    public static FlowNodeLogExt create(FlowNode node) {
        FlowNodeLogExt logExt = new FlowNodeLogExt();
        logExt.setNodeId(node.getId());
        logExt.setNodeStatus(StatusExt.valueOf(node.getError()));
        LogAction logAction = (LogAction)node.getAction(LogAction.class);
        if (logAction != null) {
            logExt.setConsoleUrl(ModelUtil.getFullItemUrl(node) + logAction.getUrlName());
            AnnotatedLargeText logText = logAction.getLogText();
            if (logText != null) {
                long logLen = logText.length();
                logExt.setLength(Math.min(MAX_RETURN_CHARS, logLen));
                logExt.setHasMore(logLen > MAX_RETURN_CHARS);
                if (logLen > 0L) {
                    StringWriter writer = new StringWriter();
                    try {
                        logText.writeHtmlTo(logLen - logExt.getLength(), (Writer)writer);
                        logExt.setText(writer.toString());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Error serializing log for", e);
                    }
                }
            }
        }
        return logExt;
    }
}

