/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.util.ModelUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class ChangeSetExt {
    private String kind;
    private int commitCount;
    private List<Commit> commits;
    private String consoleUrl;

    private static boolean resolveCommitAuthors() {
        return Boolean.getBoolean(ChangeSetExt.class.getName() + ".resolveCommitAuthors");
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public List<Commit> getCommits() {
        return this.commits;
    }

    public void setCommits(List<Commit> commits) {
        this.commits = commits;
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public static boolean hasChanges(WorkflowRun run) {
        for (ChangeLogSet changeset : run.getChangeSets()) {
            if (changeset.isEmptySet()) continue;
            return true;
        }
        return false;
    }

    public static ChangeSetExt create(ChangeLogSet<? extends ChangeLogSet.Entry> changeset, WorkflowRun run) {
        ChangeSetExt changeSetExt = new ChangeSetExt();
        changeSetExt.mapFields(changeset, run);
        return changeSetExt;
    }

    protected void mapFields(ChangeLogSet<? extends ChangeLogSet.Entry> changeset, WorkflowRun run) {
        Iterator iterator = changeset.iterator();
        RepositoryBrowser repoBrowser = changeset.getBrowser();
        this.setKind(changeset.getKind());
        this.setCommits(new ArrayList<Commit>());
        this.setConsoleUrl(this.getRunUrl(run) + "changes");
        while (iterator.hasNext()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
            Commit commit = new Commit();
            String repoUrl = ChangeSetExt.getCommitUrl(repoBrowser, entry);
            this.getCommits().add(commit);
            commit.setCommitId(entry.getCommitId());
            commit.setCommitUrl(repoUrl);
            commit.setMessage(entry.getMsg());
            commit.setAuthorJenkinsId(ChangeSetExt.resolveCommitAuthors() ? entry.getAuthor().getFullName() : "");
            commit.setTimestamp(entry.getTimestamp());
            if (commit.getTimestamp() > -1L && commit.getTimestamp() > 999999999L && commit.getTimestamp() < 999999999999L) {
                commit.setTimestamp(commit.getTimestamp() * 1000L);
            }
            commit.setConsoleUrl(this.getConsoleUrl() + "#" + commit.getCommitId());
        }
        this.setCommitCount(this.getCommits().size());
    }

    protected String getRunUrl(WorkflowRun run) {
        return ModelUtil.getFullItemUrl(run.getUrl());
    }

    static <T extends ChangeLogSet.Entry> String getCommitUrl(RepositoryBrowser<T> repoBrowser, ChangeLogSet.Entry entry) {
        if (repoBrowser == null) {
            return null;
        }
        try {
            URL changeSetLink = repoBrowser.getChangeSetLink(entry);
            if (changeSetLink == null) {
                return null;
            }
            return changeSetLink.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class Commit {
        private String commitId;
        private String commitUrl;
        private String authorJenkinsId;
        private String message;
        private long timestamp;
        private String consoleUrl;

        public String getCommitId() {
            return this.commitId;
        }

        public void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getCommitUrl() {
            return this.commitUrl;
        }

        public void setCommitUrl(String commitUrl) {
            this.commitUrl = commitUrl;
        }

        public String getAuthorJenkinsId() {
            return this.authorJenkinsId;
        }

        public void setAuthorJenkinsId(String authorJenkinsId) {
            this.authorJenkinsId = authorJenkinsId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getConsoleUrl() {
            return this.consoleUrl;
        }

        public void setConsoleUrl(String consoleUrl) {
            this.consoleUrl = consoleUrl;
        }
    }
}

