/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.causes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.model.Run;
import org.jenkinsci.plugins.pipeline.modeldefinition.causes.Messages;

public class RestartDeclarativePipelineCause
extends Cause {
    private int originRunNumber;
    private String originStage;
    private transient Run<?, ?> run;

    public RestartDeclarativePipelineCause(@NonNull Run<?, ?> original, @NonNull String originStage) {
        this.originRunNumber = original.getNumber();
        this.originStage = originStage;
    }

    public void onAddedTo(Run run) {
        super.onAddedTo(run);
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        super.onLoad(run);
        this.run = run;
    }

    public int getOriginRunNumber() {
        return this.originRunNumber;
    }

    @NonNull
    public String getOriginStage() {
        return this.originStage;
    }

    @CheckForNull
    public Run<?, ?> getOriginal() {
        return this.run.getParent().getBuildByNumber(this.originRunNumber);
    }

    public String getShortDescription() {
        return Messages.RestartedDeclarativePipelineCause_ShortDescription(this.originRunNumber, this.originStage);
    }
}

