/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AgentDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AxesDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.EnvironmentDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.ExcludesDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.InputDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.OptionsDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.PostDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.StagesDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.ToolsDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.WhenDirective;
import org.kohsuke.stapler.DataBoundConstructor;

public class MatrixDirective
extends AbstractDirective<MatrixDirective> {
    private List<AbstractDirective> axes;

    @DataBoundConstructor
    public MatrixDirective(List<AbstractDirective> axes) {
        this.axes = axes;
    }

    public List<AbstractDirective> getAxes() {
        return this.axes;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<MatrixDirective> {
        @Override
        @NonNull
        public String getName() {
            return "matrix";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Matrix";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            descriptors.add(Jenkins.get().getDescriptorByType(AxesDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(ExcludesDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(AgentDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(EnvironmentDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(InputDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(OptionsDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(PostDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(ToolsDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(WhenDirective.DescriptorImpl.class));
            descriptors.add(Jenkins.get().getDescriptorByType(StagesDirective.DescriptorImpl.class));
            return descriptors;
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull MatrixDirective matrix) {
            StringBuilder result = new StringBuilder("matrix {\n");
            if (matrix.axes != null) {
                matrix.axes.stream().forEach(a -> result.append(a.toGroovy(false)).append("\n"));
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

