/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.util;

import java.util.Objects;

public class MavenVersion {
    public static final MavenVersion UNKNOWN = new MavenVersion(-1, -1, -1);
    private int major;
    private int minor;
    private int increment;

    public static MavenVersion fromString(String str) {
        try {
            String[] parts = str.split("[.\\-]");
            return new MavenVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("'" + str + "' is not a valid maven version", ex);
        }
    }

    public MavenVersion(int major, int minor, int increment) {
        this.major = major;
        this.minor = minor;
        this.increment = increment;
    }

    public boolean isAtLeast(int wantedMajor, int wantedMinor) {
        return this.major > wantedMajor || this.major == wantedMajor && this.minor >= wantedMinor;
    }

    public boolean isAtLeast(int wantedMajor, int wantedMinor, int wantedIncrement) {
        return this.major > wantedMajor || this.major == wantedMajor && this.minor > wantedMinor || this.major == wantedMajor && this.minor == wantedMinor && this.increment >= wantedIncrement;
    }

    public String toString() {
        return this.major == -1 ? "UNKNOWN" : this.major + "." + this.minor + "." + this.increment;
    }

    public int hashCode() {
        return Objects.hash(this.increment, this.major, this.minor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenVersion other = (MavenVersion)obj;
        return this.increment == other.increment && this.major == other.major && this.minor == other.minor;
    }
}

