/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.tasks.TasksPublisher;
import hudson.plugins.tasks.TasksResultAction;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.publishers.AbstractHealthAwarePublisher;
import org.jenkinsci.plugins.pipeline.maven.publishers.MavenPipelinePublisherException;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class TasksScannerPublisher
extends AbstractHealthAwarePublisher {
    private static final Logger LOGGER = Logger.getLogger(TasksScannerPublisher.class.getName());
    private static final long serialVersionUID = 1L;
    private String highPriorityTaskIdentifiers = "";
    private String normalPriorityTaskIdentifiers = "";
    private String lowPriorityTaskIdentifiers = "";
    private boolean ignoreCase = false;
    private String pattern = "";
    private String excludePattern = "";
    private boolean asRegexp = false;

    @DataBoundConstructor
    public TasksScannerPublisher() {
    }

    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        try {
            Class.forName("hudson.plugins.tasks.TasksPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/Task+Scanner+Plugin", "Task Scanner Plugin");
            listener.getLogger().println(" not found, don't display results of source code scanning for 'TODO' and 'FIXME' in pipeline screen.");
            return;
        }
        ArrayList<String> sourceDirectoriesPatterns = new ArrayList<String>();
        for (Element executionEvent : XmlUtils.getExecutionEvents(mavenSpyLogsElt, "ProjectSucceeded", "ProjectFailed")) {
            Element buildElement = XmlUtils.getUniqueChildElementOrNull(executionEvent, "project", "build");
            if (buildElement == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Ignore execution event with missing 'build' child:" + XmlUtils.toString(executionEvent));
                continue;
            }
            Element projectElt = XmlUtils.getUniqueChildElement(executionEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            String sourceDirectory = buildElement.getAttribute("sourceDirectory");
            if (Objects.equals(sourceDirectory, "${project.basedir}/src/main/java")) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Skip task scanning for " + XmlUtils.toString(executionEvent));
                continue;
            }
            String sourceDirectoryRelativePath = XmlUtils.getPathInWorkspace(sourceDirectory, workspace);
            if (workspace.child(sourceDirectoryRelativePath).exists()) {
                sourceDirectoriesPatterns.add(sourceDirectoryRelativePath + fileSeparatorOnAgent + "**" + fileSeparatorOnAgent + "*");
                listener.getLogger().println("[withMaven] openTasksPublisher - Scan Tasks for Maven artifact " + mavenArtifact.getId() + " in source directory " + sourceDirectoryRelativePath);
                continue;
            }
            LOGGER.log(Level.FINE, "Skip task scanning for {0}, folder {1} does not exist", new Object[]{mavenArtifact, sourceDirectoryRelativePath});
        }
        if (sourceDirectoriesPatterns.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] openTasksPublisher - no folder to scan");
            }
            return;
        }
        TasksResultAction tasksResult = (TasksResultAction)run.getAction(TasksResultAction.class);
        if (tasksResult != null) {
            run.removeAction((Action)tasksResult);
        }
        TasksPublisher tasksPublisher = new TasksPublisher();
        String pattern = this.pattern == null || this.pattern.isEmpty() ? XmlUtils.join(sourceDirectoriesPatterns, ",") : this.pattern;
        tasksPublisher.setPattern(pattern);
        tasksPublisher.setExcludePattern((String)Optional.ofNullable(this.excludePattern).map(String::trim).orElse(null));
        tasksPublisher.setHigh(Optional.ofNullable(this.highPriorityTaskIdentifiers).filter(Predicate.not(String::isEmpty)).orElse("FIXME"));
        tasksPublisher.setNormal(Optional.ofNullable(this.normalPriorityTaskIdentifiers).filter(Predicate.not(String::isEmpty)).orElse("TODO"));
        tasksPublisher.setLow((String)Optional.ofNullable(this.lowPriorityTaskIdentifiers).map(String::trim).orElse(null));
        tasksPublisher.setIgnoreCase(this.ignoreCase);
        tasksPublisher.setAsRegexp(this.asRegexp);
        this.setHealthAwarePublisherAttributes(tasksPublisher);
        try {
            tasksPublisher.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            listener.error("[withMaven] openTasksPublisher - exception scanning tasks in " + pattern + ": " + String.valueOf(e));
            LOGGER.log(Level.WARNING, "Exception scanning tasks in  " + pattern, e);
            throw new MavenPipelinePublisherException("openTasksPublisher", "scanning tasks in " + pattern, e);
        }
    }

    public String getHighPriorityTaskIdentifiers() {
        return this.highPriorityTaskIdentifiers;
    }

    @DataBoundSetter
    public void setHighPriorityTaskIdentifiers(String highPriorityTaskIdentifiers) {
        this.highPriorityTaskIdentifiers = highPriorityTaskIdentifiers;
    }

    public String getNormalPriorityTaskIdentifiers() {
        return this.normalPriorityTaskIdentifiers;
    }

    @DataBoundSetter
    public void setNormalPriorityTaskIdentifiers(String normalPriorityTaskIdentifiers) {
        this.normalPriorityTaskIdentifiers = normalPriorityTaskIdentifiers;
    }

    public String getLowPriorityTaskIdentifiers() {
        return this.lowPriorityTaskIdentifiers;
    }

    @DataBoundSetter
    public void setLowPriorityTaskIdentifiers(String lowPriorityTaskIdentifiers) {
        this.lowPriorityTaskIdentifiers = lowPriorityTaskIdentifiers;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @DataBoundSetter
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public boolean isAsRegexp() {
        return this.asRegexp;
    }

    @DataBoundSetter
    public void setAsRegexp(boolean asRegexp) {
        this.asRegexp = asRegexp;
    }

    @Symbol(value={"openTasksPublisher"})
    @OptionalExtension(requirePlugins={"tasks"})
    public static class DescriptorImpl
    extends AbstractHealthAwarePublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return Messages.publisher_tasks_scanner_description();
        }

        @Override
        public int ordinal() {
            return 100;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-task-scanner";
        }
    }
}

