/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.dao.CacheStats;
import org.jenkinsci.plugins.pipeline.maven.dao.MonitoringPipelineMavenPluginDaoDecorator;
import org.jenkinsci.plugins.pipeline.maven.listeners.DownstreamPipelineTriggerRunListener;

public class DaoHelper {
    private static final Logger LOGGER = Logger.getLogger(DownstreamPipelineTriggerRunListener.class.getName());
    private static final AtomicInteger GET_GENERATED_ARTIFACTS_HITS = new AtomicInteger();
    private static final AtomicInteger GET_GENERATED_ARTIFACTS_MISSES = new AtomicInteger();
    private static final AtomicInteger LIST_DOWNSTREAM_JOBS_HITS = new AtomicInteger();
    private static final AtomicInteger LIST_DOWNSTREAM_JOBS_MISSES = new AtomicInteger();
    private GlobalPipelineMavenConfig globalPipelineMavenConfig;
    private Map<String, List<MavenArtifact>> generatedArtifactsCache = new HashMap<String, List<MavenArtifact>>();
    private Map<String, Map<MavenArtifact, SortedSet<String>>> downstreamJobsByArtifact = new HashMap<String, Map<MavenArtifact, SortedSet<String>>>();

    public DaoHelper(GlobalPipelineMavenConfig globalPipelineMavenConfig) {
        this.globalPipelineMavenConfig = globalPipelineMavenConfig;
    }

    @NonNull
    List<MavenArtifact> getGeneratedArtifacts(@NonNull String jobFullName, int buildNumber) {
        String key = jobFullName + "#" + buildNumber;
        LOGGER.log(Level.FINER, "calling getGeneratedArtifacts {0} {1}, cache size: {2}", new Object[]{jobFullName, buildNumber, this.generatedArtifactsCache.size()});
        if (this.generatedArtifactsCache.containsKey(key)) {
            LOGGER.log(Level.FINER, "cache hit for getGeneratedArtifacts {0} {1}", new Object[]{jobFullName, buildNumber});
            GET_GENERATED_ARTIFACTS_HITS.incrementAndGet();
        } else {
            GET_GENERATED_ARTIFACTS_MISSES.incrementAndGet();
        }
        return this.generatedArtifactsCache.computeIfAbsent(key, k -> this.globalPipelineMavenConfig.getDao().getGeneratedArtifacts(jobFullName, buildNumber));
    }

    Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifact(String jobFullName, int buildNumber) {
        String key = jobFullName + "#" + buildNumber;
        if (this.downstreamJobsByArtifact.containsKey(key)) {
            LOGGER.log(Level.FINER, "cache hit for listDownstreamJobsByArtifact {0} {1}", new Object[]{jobFullName, buildNumber});
            LIST_DOWNSTREAM_JOBS_HITS.incrementAndGet();
        } else {
            LIST_DOWNSTREAM_JOBS_MISSES.incrementAndGet();
        }
        return this.downstreamJobsByArtifact.computeIfAbsent(key, k -> this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(jobFullName, buildNumber));
    }

    static {
        MonitoringPipelineMavenPluginDaoDecorator.registerCacheStatsSupplier(() -> new CacheStats("getGeneratedArtifacts", GET_GENERATED_ARTIFACTS_HITS.get(), GET_GENERATED_ARTIFACTS_MISSES.get()));
        MonitoringPipelineMavenPluginDaoDecorator.registerCacheStatsSupplier(() -> new CacheStats("listDownstreamJobsByArtifact", LIST_DOWNSTREAM_JOBS_HITS.get(), LIST_DOWNSTREAM_JOBS_MISSES.get()));
    }
}

