/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.util;

import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;

public class TaskListenerTraceWrapper {
    private final TaskListener taskListener;
    private final boolean traceability;
    private final PrintStream console;

    public TaskListenerTraceWrapper(TaskListener taskListener, boolean traceability) {
        this.taskListener = taskListener;
        this.traceability = traceability;
        this.console = taskListener.getLogger();
    }

    public void trace(String s) {
        if (this.traceability) {
            this.console.println(s);
        }
    }

    public void trace(Object o) {
        if (this.traceability) {
            this.console.println(o);
        }
    }

    public void traceHyperlink(String url, String text) throws IOException {
        if (this.traceability) {
            this.taskListener.hyperlink(url, text);
        }
    }

    public void println(CharSequence s) {
        this.console.println(s);
    }

    public PrintStream format(String format, Object ... args) {
        return this.console.format(format, args);
    }

    public PrintStream formatTrace(String format, Object ... args) {
        if (this.traceability) {
            return this.console.format(format, args);
        }
        return this.console;
    }
}

