/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.findbugs.FindBugsPublisher;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.publishers.AbstractHealthAwarePublisher;
import org.jenkinsci.plugins.pipeline.maven.publishers.MavenPipelinePublisherException;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class SpotBugsAnalysisPublisher
extends AbstractHealthAwarePublisher {
    private static final Logger LOGGER = Logger.getLogger(SpotBugsAnalysisPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SpotBugsAnalysisPublisher() {
    }

    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        List<Element> spotbugsEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, "com.github.spotbugs", "spotbugs-maven-plugin", "spotbugs", "MojoSucceeded", "MojoFailed");
        if (spotbugsEvents.isEmpty()) {
            LOGGER.log(Level.FINE, "No com.github.spotbugs:spotbugs-maven-plugin:spotbugs execution found");
            return;
        }
        try {
            Class.forName("hudson.plugins.findbugs.FindBugsPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/FindBugs+Plugin", "FindBugs Plugin");
            listener.getLogger().println(" not found, don't display com.github.spotbugs:spotbugs-maven-plugin:spotbugs results in pipeline screen.");
            return;
        }
        for (Element spotbugsEvent : spotbugsEvents) {
            String findBugsEventType = spotbugsEvent.getAttribute("type");
            if (!findBugsEventType.equals("MojoSucceeded") && !findBugsEventType.equals("MojoFailed")) continue;
            Element pluginElt = XmlUtils.getUniqueChildElement(spotbugsEvent, "plugin");
            Element xmlOutputDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "xmlOutputDirectory");
            Element projectElt = XmlUtils.getUniqueChildElement(spotbugsEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (xmlOutputDirectoryElt == null) {
                listener.getLogger().println("[withMaven] No <xmlOutputDirectoryElt> element found for <plugin> in " + XmlUtils.toString(spotbugsEvent));
                continue;
            }
            String xmlOutputDirectory = XmlUtils.resolveMavenPlaceholders(xmlOutputDirectoryElt, projectElt);
            if (xmlOutputDirectory == null) {
                listener.getLogger().println("[withMaven] could not resolve placeholder '${project.build.directory}' or '${basedir}' in " + XmlUtils.toString(spotbugsEvent));
                continue;
            }
            xmlOutputDirectory = XmlUtils.getPathInWorkspace(xmlOutputDirectory, workspace);
            String spotbugsResultsFile = xmlOutputDirectory + "/spotbugsXml.xml";
            listener.getLogger().println("[withMaven] SpotBugsPublisher - Archive SpotBugs analysis results for Maven artifact " + mavenArtifact.toString() + " generated by " + String.valueOf(pluginInvocation) + ": " + spotbugsResultsFile);
            FindBugsPublisher findBugsPublisher = new FindBugsPublisher();
            findBugsPublisher.setPattern(spotbugsResultsFile);
            this.setHealthAwarePublisherAttributes(findBugsPublisher);
            try {
                findBugsPublisher.perform(run, workspace, launcher, listener);
            }
            catch (Exception e) {
                listener.error("[withMaven] SpotBugsPublisher - exception archiving FindBugs results for Maven artifact " + mavenArtifact.toString() + " generated by " + String.valueOf(pluginInvocation) + ": " + String.valueOf(e));
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(spotbugsEvent), e);
                throw new MavenPipelinePublisherException("SpotBugsPublisher", "archiving FindBugs results for Maven artifact " + mavenArtifact.getId() + " generated by " + pluginInvocation.getId(), e);
            }
        }
    }

    @Symbol(value={"spotbugsPublisher"})
    @OptionalExtension(requirePlugins={"findbugs"})
    public static class DescriptorImpl
    extends AbstractHealthAwarePublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return Messages.publisher_spotbugs_analysis_description();
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-publish-spotbugs-results";
        }
    }
}

