/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.JUnitTask;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.junit.pipeline.JUnitResultsStepExecution;
import hudson.tasks.test.PipelineTestDetails;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.maven.publishers.MavenPipelinePublisherException;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class JUnitUtils {
    private static final Logger LOGGER = Logger.getLogger(JUnitUtils.class.getName());

    static JUnitResultArchiver buildArchiver(String testResults, boolean keepLongStdio, Double healthScaleFactor) {
        JUnitResultArchiver archiver = new JUnitResultArchiver(testResults);
        archiver.setAllowEmptyResults(true);
        archiver.setKeepLongStdio(keepLongStdio);
        if (healthScaleFactor != null) {
            archiver.setHealthScaleFactor(healthScaleFactor.doubleValue());
        }
        return archiver;
    }

    static void archiveResults(StepContext context, JUnitResultArchiver archiver, String testResults, String publisherName) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        try {
            TestResultSummary testResultSummary;
            FlowNode node = (FlowNode)context.get(FlowNode.class);
            String nodeId = node.getId();
            List enclosingBlocks = JUnitResultsStepExecution.getEnclosingStagesAndParallels((FlowNode)node);
            PipelineTestDetails pipelineTestDetails = new PipelineTestDetails();
            pipelineTestDetails.setNodeId(nodeId);
            pipelineTestDetails.setEnclosingBlocks(JUnitResultsStepExecution.getEnclosingBlockIds((List)enclosingBlocks));
            pipelineTestDetails.setEnclosingBlockNames(JUnitResultsStepExecution.getEnclosingBlockNames((List)enclosingBlocks));
            if (LOGGER.isLoggable(Level.FINER)) {
                listener.getLogger().println("[withMaven] " + publisherName + " - collect test reports: testResults=" + archiver.getTestResults() + ", healthScaleFactor=" + archiver.getHealthScaleFactor());
            }
            if ((testResultSummary = JUnitResultArchiver.parseAndSummarize((JUnitTask)archiver, (PipelineTestDetails)pipelineTestDetails, (Run)run, (FilePath)workspace, (Launcher)launcher, (TaskListener)listener)) == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] " + publisherName + " - no unit test results found, ignore");
                }
            } else if (testResultSummary.getFailCount() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] " + publisherName + " - unit tests are all successful");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] " + publisherName + " - " + testResultSummary.getFailCount() + " unit test failure(s) found, mark job as unstable");
                }
                node.addAction((Action)new WarningAction(Result.UNSTABLE).withMessage(testResultSummary.getFailCount() + " unit test failure(s) found"));
                run.setResult(Result.UNSTABLE);
            }
        }
        catch (RuntimeException e) {
            listener.error("[withMaven] " + publisherName + " - exception archiving JUnit results " + testResults + ": " + String.valueOf(e));
            LOGGER.log(Level.WARNING, "Exception processing " + testResults, e);
            throw new MavenPipelinePublisherException(publisherName, "archiving JUnit results " + testResults, e);
        }
    }
}

