/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class GeneratedArtifactsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(GeneratedArtifactsPublisher.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean archiveFilesDisabled = false;
    private boolean fingerprintFilesDisabled = false;

    @DataBoundConstructor
    public GeneratedArtifactsPublisher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        ArtifactManager artifactManager = run.pickArtifactManager();
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        List<MavenArtifact> join = XmlUtils.listGeneratedArtifacts(mavenSpyLogsElt, true);
        HashMap<CallSite, String> artifactsToArchive = new HashMap<CallSite, String>();
        HashMap<CallSite, String> artifactsToFingerPrint = new HashMap<CallSite, String>();
        for (MavenArtifact mavenArtifact : join) {
            try {
                FilePath mavenGeneratedArtifact;
                if (mavenArtifact.getFile() == null || mavenArtifact.getFile().isEmpty()) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] artifactsPublisher - Can't archive maven artifact with no file attached: " + String.valueOf(mavenArtifact));
                    continue;
                }
                if (!mavenArtifact.getFile().endsWith("." + mavenArtifact.getExtension()) && (mavenGeneratedArtifact = workspace.child(XmlUtils.getPathInWorkspace(mavenArtifact.getFile(), workspace))).isDirectory()) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    listener.getLogger().println("[withMaven] artifactsPublisher - Skip archiving for generated maven artifact of type directory (it's likely to be target/classes, see JENKINS-43714) " + String.valueOf(mavenArtifact));
                    continue;
                }
                String artifactPathInArchiveZone = mavenArtifact.getGroupId().replace(".", "/") + "/" + mavenArtifact.getArtifactId() + "/" + mavenArtifact.getBaseVersion() + "/" + mavenArtifact.getFileNameWithBaseVersion();
                String artifactPathInWorkspace = XmlUtils.getPathInWorkspace(mavenArtifact.getFile(), workspace).replace('\\', '/');
                if (artifactPathInWorkspace == null || artifactPathInWorkspace.isEmpty()) {
                    listener.error("[withMaven] artifactsPublisher - Invalid path in the workspace (" + workspace.getRemote() + ") for artifact " + String.valueOf(mavenArtifact));
                    continue;
                }
                if (Objects.equals(artifactPathInArchiveZone, mavenArtifact.getFile())) {
                    listener.error("[withMaven] artifactsPublisher - Failed to relativize '" + mavenArtifact.getFile() + "' in workspace '" + workspace.getRemote() + "'");
                    continue;
                }
                FilePath artifactFilePath = new FilePath(workspace, artifactPathInWorkspace);
                if (artifactFilePath.exists()) {
                    listener.getLogger().println("[withMaven] artifactsPublisher - Archive artifact " + artifactPathInWorkspace + " under " + artifactPathInArchiveZone);
                    artifactsToArchive.put((CallSite)((Object)artifactPathInArchiveZone), artifactPathInWorkspace);
                    if (this.fingerprintFilesDisabled) continue;
                    String artifactDigest = artifactFilePath.digest();
                    artifactsToFingerPrint.put((CallSite)((Object)artifactPathInArchiveZone), artifactDigest);
                    continue;
                }
                listener.getLogger().println("[withMaven] artifactsPublisher - FAILURE to archive " + artifactPathInWorkspace + " under " + artifactPathInArchiveZone + ", file not found in workspace " + String.valueOf(workspace));
            }
            catch (IOException | RuntimeException e) {
                listener.error("[withMaven] artifactsPublisher - WARNING: Exception archiving and fingerprinting " + String.valueOf(mavenArtifact) + ", skip archiving of the artifacts");
                e.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] artifactsPublisher - Archive and fingerprint artifacts " + String.valueOf(artifactsToArchive) + " located in workspace " + workspace.getRemote());
        }
        if (!this.archiveFilesDisabled) {
            try {
                artifactManager.archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactsToArchive);
            }
            catch (IOException e) {
                throw new IOException("Exception archiving " + String.valueOf(artifactsToArchive), e);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Exception archiving " + String.valueOf(artifactsToArchive), e);
            }
        }
        if (!this.fingerprintFilesDisabled) {
            GeneratedArtifactsPublisher e = this;
            synchronized (e) {
                FingerprintMap fingerprintMap = Jenkins.get().getFingerprintMap();
                for (Map.Entry artifactToFingerprint : artifactsToFingerPrint.entrySet()) {
                    String artifactPathInArchiveZone = (String)artifactToFingerprint.getKey();
                    String artifactMd5 = (String)artifactToFingerprint.getValue();
                    fingerprintMap.getOrCreate(run, artifactPathInArchiveZone, artifactMd5).addFor(run);
                }
            }
            Fingerprinter.FingerprintAction fingerprintAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
            if (fingerprintAction == null) {
                run.addAction((Action)new Fingerprinter.FingerprintAction(run, artifactsToFingerPrint));
            } else {
                fingerprintAction.add(artifactsToFingerPrint);
            }
        }
    }

    public boolean isFingerprintFilesDisabled() {
        return this.fingerprintFilesDisabled;
    }

    @DataBoundSetter
    public void setFingerprintFilesDisabled(boolean fingerprintFilesDisabled) {
        this.fingerprintFilesDisabled = fingerprintFilesDisabled;
    }

    public boolean isArchiveFilesDisabled() {
        return this.archiveFilesDisabled;
    }

    @DataBoundSetter
    public void setArchiveFilesDisabled(boolean archiveFilesDisabled) {
        this.archiveFilesDisabled = archiveFilesDisabled;
    }

    @Symbol(value={"artifactsPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return Messages.publisher_generated_artifacts_description();
        }

        @Override
        public int ordinal() {
            return 1;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-archive-generated-artifacts";
        }
    }
}

