/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.w3c.dom.Element;

public class DependenciesLister {
    @NonNull
    public static List<MavenDependency> listDependencies(Element mavenSpyLogs, Logger logger) {
        HashSet<MavenDependency> result = new HashSet<MavenDependency>();
        for (Element dependencyResolutionResult : XmlUtils.getChildrenElements(mavenSpyLogs, "DependencyResolutionResult")) {
            Element resolvedDependenciesElt = XmlUtils.getUniqueChildElementOrNull(dependencyResolutionResult, "resolvedDependencies");
            if (resolvedDependenciesElt == null) continue;
            for (Element dependencyElt : XmlUtils.getChildrenElements(resolvedDependenciesElt, "dependency")) {
                MavenDependency dependencyArtifact = XmlUtils.newMavenDependency(dependencyElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(dependencyElt, "file");
                if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    logger.log(Level.WARNING, "listDependencies: no associated file found for " + String.valueOf(dependencyArtifact) + " in " + XmlUtils.toString(dependencyElt));
                } else {
                    dependencyArtifact.setFile(fileElt.getTextContent().trim());
                }
                result.add(dependencyArtifact);
            }
        }
        return new ArrayList<MavenDependency>(result);
    }

    @NonNull
    public static List<MavenArtifact> listParentProjects(Element mavenSpyLogs, Logger logger) {
        HashSet<MavenArtifact> result = new HashSet<MavenArtifact>();
        for (Element dependencyResolutionResult : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectStarted")) {
            Element parentProjectElt = XmlUtils.getUniqueChildElementOrNull(dependencyResolutionResult, "parentProject");
            if (parentProjectElt == null) continue;
            MavenArtifact parentProject = new MavenArtifact();
            parentProject.setGroupId(parentProjectElt.getAttribute("groupId"));
            parentProject.setArtifactId(parentProjectElt.getAttribute("artifactId"));
            parentProject.setVersion(parentProjectElt.getAttribute("version"));
            parentProject.setBaseVersion(parentProject.getVersion());
            parentProject.setSnapshot(parentProject.getVersion().endsWith("-SNAPSHOT"));
            result.add(parentProject);
        }
        return new ArrayList<MavenArtifact>(result);
    }
}

