/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.listeners.AbstractWorkflowRunListener;

@Extension
public class DatabaseSyncRunListener
extends AbstractWorkflowRunListener {
    private GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public DatabaseSyncRunListener() {
        this(GlobalPipelineMavenConfig.get());
    }

    @VisibleForTesting
    DatabaseSyncRunListener(GlobalPipelineMavenConfig globalPipelineMavenConfig) {
        this.globalPipelineMavenConfig = globalPipelineMavenConfig;
    }

    public void onDeleted(Run<?, ?> run) {
        this.globalPipelineMavenConfig.getDao().deleteBuild(run.getParent().getFullName(), run.getNumber());
    }

    public void onInitialize(Run<?, ?> run) {
        super.onInitialize(run);
        for (Cause cause : run.getCauses()) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
            String upstreamJobName = upstreamCause.getUpstreamProject();
            int upstreamBuildNumber = upstreamCause.getUpstreamBuild();
            this.globalPipelineMavenConfig.getDao().recordBuildUpstreamCause(upstreamJobName, upstreamBuildNumber, run.getParent().getFullName(), run.getNumber());
        }
    }

    public void onCompleted(Run<?, ?> workflowRun, @NonNull TaskListener listener) {
        super.onCompleted(workflowRun, listener);
        if (!this.shouldRun(workflowRun, listener)) {
            return;
        }
        Result result = workflowRun.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        this.globalPipelineMavenConfig.getDao().updateBuildOnCompletion(workflowRun.getParent().getFullName(), workflowRun.getNumber(), result.ordinal, workflowRun.getStartTimeInMillis(), Math.max(System.currentTimeMillis() - workflowRun.getStartTimeInMillis(), 0L));
    }
}

