/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.cause;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;

public class MavenDependencyCauseHelper {
    @NonNull
    public static List<MavenArtifact> isSameCause(MavenDependencyCause newMavenCause, Cause oldMavenCause) {
        if (!(oldMavenCause instanceof MavenDependencyCause)) {
            return Collections.emptyList();
        }
        List newCauseArtifacts = (List)Preconditions.checkNotNull(newMavenCause.getMavenArtifacts(), (Object)"newMavenCause.mavenArtifacts should not be null");
        List oldCauseArtifacts = (List)Preconditions.checkNotNull(((MavenDependencyCause)oldMavenCause).getMavenArtifacts(), (Object)"oldMavenCause.mavenArtifacts should not be null");
        ArrayList<MavenArtifact> matchingArtifacts = new ArrayList<MavenArtifact>();
        for (MavenArtifact newCauseArtifact : newCauseArtifacts) {
            if (newCauseArtifact.isSnapshot() && newCauseArtifact.getVersion().contains("SNAPSHOT")) continue;
            for (MavenArtifact oldCauseArtifact : oldCauseArtifacts) {
                if (!Objects.equals(newCauseArtifact.getGroupId(), oldCauseArtifact.getGroupId()) || !Objects.equals(newCauseArtifact.getArtifactId(), oldCauseArtifact.getArtifactId()) || !Objects.equals(newCauseArtifact.getVersion(), oldCauseArtifact.getVersion()) || !Objects.equals(newCauseArtifact.getBaseVersion(), oldCauseArtifact.getBaseVersion()) || !Objects.equals(newCauseArtifact.getClassifier(), oldCauseArtifact.getClassifier()) || !Objects.equals(newCauseArtifact.getType(), oldCauseArtifact.getType())) continue;
                matchingArtifacts.add(newCauseArtifact);
            }
        }
        return matchingArtifacts;
    }

    public static List<MavenArtifact> isSameCause(MavenDependencyCause newMavenCause, List<Cause> oldMavenCauses) {
        ArrayList<MavenArtifact> matchingArtifacts = new ArrayList<MavenArtifact>();
        for (Cause oldMavenCause : oldMavenCauses) {
            matchingArtifacts.addAll(MavenDependencyCauseHelper.isSameCause(newMavenCause, oldMavenCause));
        }
        return matchingArtifacts;
    }
}

