/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.lib.oras;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.slaves.WorkspaceList;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import jenkins.model.Jenkins;
import land.oras.ArtifactType;
import land.oras.ContainerRef;
import land.oras.Manifest;
import land.oras.Registry;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

@Restricted(value={NoExternalUse.class})
public class OrasRetriever
extends LibraryRetriever {
    public static final ArtifactType ARTIFACT_TYPE = ArtifactType.from((String)"application/vnd.jenkins.lib.manifest.v1+json");
    private static final Logger LOG = LoggerFactory.getLogger(OrasRetriever.class);
    private String credentialsId;
    private final String containerRef;

    @DataBoundConstructor
    public OrasRetriever(String containerRef) {
        this.containerRef = containerRef;
    }

    public void retrieve(@NonNull String name, @NonNull String version, boolean changelog, @NonNull FilePath target, @NonNull Run<?, ?> run, @NonNull TaskListener listener) throws Exception {
        Job item = run.getParent();
        Registry registry = OrasRetriever.buildRegistry((Item)item, this.credentialsId);
        StandardUsernamePasswordCredentials currentCredentials = OrasRetriever.getCredentials((Item)item, this.credentialsId);
        if (currentCredentials != null) {
            CredentialsProvider.track((Item)item, (Credentials)currentCredentials);
        }
        ContainerRef libraryRef = ContainerRef.parse((String)(this.containerRef + ":" + version));
        Manifest manifest = registry.getManifest(libraryRef);
        OrasRetriever.ensureArtifactType(manifest);
        String digest = manifest.getDigest();
        String revision = manifest.getAnnotations().getOrDefault("org.opencontainers.image.revision", "unknown");
        String source = manifest.getAnnotations().getOrDefault("org.opencontainers.image.source", "unknown");
        FilePath dir = this.getDownloadFolder(name, run);
        Computer computer = Jenkins.get().toComputer();
        if (computer == null) {
            throw new IOException(Jenkins.get().getDisplayName() + " may be offline");
        }
        try (WorkspaceList.Lease lease = computer.getWorkspaceList().allocate(dir);){
            registry.pullArtifact(libraryRef, Path.of(lease.path.getRemote(), new String[0]), true);
            LOG.trace("Pulled library {} with version {} (digest: {}) (revision: {}) to {}", new Object[]{this.containerRef, version, digest, revision, lease.path.getRemote()});
            if (lease.path.list().size() == 1 && ((FilePath)lease.path.list().get(0)).isDirectory()) {
                LOG.trace("Moving contents of {} to the root of the library", (Object)((FilePath)lease.path.list().get(0)).getName());
                String sharedLibUpperDir = ((FilePath)lease.path.list().get(0)).getName();
                if (!(sharedLibUpperDir.equals("src") || sharedLibUpperDir.equals("vars") || sharedLibUpperDir.equals("resources"))) {
                    ((FilePath)lease.path.list().get(0)).moveAllChildrenTo(lease.path);
                    LOG.trace("Moved contents of {} to the root of the library", (Object)((FilePath)lease.path.list().get(0)).getName());
                } else {
                    LOG.trace("No need to move contents of {} to the root of the library, as it is already in the correct location", (Object)sharedLibUpperDir);
                }
            } else {
                LOG.trace("Library {} already has the correct structure, no need to move contents", (Object)lease.path.getRemote());
            }
            lease.path.copyRecursiveTo(target);
            LOG.debug("Library copied to target directory: {}", (Object)target.getRemote());
        }
        listener.getLogger().printf("Using library from %s@%s at revision %s and source %s%n", this.containerRef, digest, revision, source);
    }

    public void retrieve(@NonNull String name, @NonNull String version, @NonNull FilePath target, @NonNull Run<?, ?> run, @NonNull TaskListener listener) throws Exception {
        this.retrieve(name, version, false, target, run, listener);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getContainerRef() {
        return this.containerRef;
    }

    private FilePath getDownloadFolder(String name, Run<?, ?> run) throws IOException {
        FilePath baseWorkspace;
        if (run.getParent() instanceof TopLevelItem) {
            baseWorkspace = Jenkins.get().getWorkspaceFor((TopLevelItem)run.getParent());
            if (baseWorkspace == null) {
                throw new IOException(Jenkins.get().getDisplayName() + " may be offline");
            }
        } else {
            throw new AbortException("Cannot check out in non-top-level build");
        }
        FilePath dir = baseWorkspace.withSuffix(OrasRetriever.getFilePathSuffix() + "libs").child(name);
        return dir;
    }

    private static String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    private static Registry buildRegistry(Item item, String credentialsId) {
        Registry.Builder builder = Registry.builder();
        if (credentialsId == null || credentialsId.isEmpty()) {
            return builder.insecure().build();
        }
        StandardUsernamePasswordCredentials credentials = OrasRetriever.getCredentials(item, credentialsId);
        if (credentials == null) {
            throw new IllegalArgumentException("No credentials found with ID: " + credentialsId);
        }
        return builder.defaults(credentials.getUsername(), credentials.getPassword().getPlainText()).build();
    }

    @Nullable
    public static StandardUsernamePasswordCredentials getCredentials(Item item, String credentialsId) {
        if (credentialsId == null || credentialsId.isEmpty()) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}));
    }

    private static void ensureArtifactType(Manifest manifest) {
        if (!Objects.equals(ARTIFACT_TYPE.getMediaType(), manifest.getArtifactType().getMediaType())) {
            throw new IllegalArgumentException("The container reference does not point to a valid pipeline manifest. Make sure to set application/vnd.jenkins.pipeline.manifest.v1+json artifact type when pushing the artifact");
        }
    }

    @Symbol(value={"oras"})
    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class DescriptorImpl
    extends LibraryRetrieverDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Pipeline Library from ORAS";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeCurrentValue(credentialsId);
        }
    }
}

