/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.GlobalVariableSet;
import org.jenkinsci.plugins.workflow.cps.global.UserDefinedGlobalVariable;
import org.jenkinsci.plugins.workflow.cps.replay.OriginalLoadedScripts;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.jenkinsci.plugins.workflow.libs.ClasspathAdder;
import org.jenkinsci.plugins.workflow.libs.LibrariesAction;
import org.jenkinsci.plugins.workflow.libs.LibraryCachingConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRecord;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMBasedRetriever;

@Extension
public class LibraryAdder
extends ClasspathAdder {
    private static final Logger LOGGER = Logger.getLogger(LibraryAdder.class.getName());
    private static ConcurrentHashMap<String, ReentrantReadWriteLock> cacheRetrieveLock = new ConcurrentHashMap();

    @NonNull
    static ReentrantReadWriteLock getReadWriteLockFor(@NonNull String name) {
        return cacheRetrieveLock.computeIfAbsent(name, s -> new ReentrantReadWriteLock(true));
    }

    @Override
    public List<ClasspathAdder.Addition> add(CpsFlowExecution execution, List<String> libraries, HashMap<String, Boolean> changelogs) throws Exception {
        Queue.Executable executable = execution.getOwner().getExecutable();
        if (!(executable instanceof Run)) {
            return Collections.emptyList();
        }
        Run build = (Run)executable;
        HashMap<String, String> libraryVersions = new HashMap<String, String>();
        HashMap<Object, Boolean> libraryChangelogs = new HashMap<Object, Boolean>();
        HashMap<Object, String> librariesUnparsed = new HashMap<Object, String>();
        for (String library : libraries) {
            String[] parsed = LibraryAdder.parse(library);
            libraryVersions.put(parsed[0], parsed[1]);
            libraryChangelogs.put(parsed[0], changelogs.get(library));
            librariesUnparsed.put(parsed[0], library);
        }
        ArrayList<ClasspathAdder.Addition> additions = new ArrayList<ClasspathAdder.Addition>();
        LibrariesAction action = (LibrariesAction)build.getAction(LibrariesAction.class);
        if (action != null) {
            for (LibraryRecord record : action.getLibraries()) {
                FilePath libDir = new FilePath(execution.getOwner().getRootDir()).child("libs/" + record.getDirectoryName());
                for (String root : new String[]{"src", "vars"}) {
                    FilePath dir = libDir.child(root);
                    if (!dir.isDirectory()) continue;
                    additions.add(new ClasspathAdder.Addition(dir.toURI().toURL(), record.trusted));
                }
                String unparsed = (String)librariesUnparsed.get(record.name);
                if (unparsed == null) continue;
                libraries.remove(unparsed);
            }
            return additions;
        }
        LinkedHashMap<String, LibraryRecord> librariesAdded = new LinkedHashMap<String, LibraryRecord>();
        HashMap<String, LibraryRetriever> retrievers = new HashMap<String, LibraryRetriever>();
        TaskListener listener = execution.getOwner().getListener();
        for (LibraryResolver kind : ExtensionList.lookup(LibraryResolver.class)) {
            boolean kindTrusted = kind.isTrusted();
            for (LibraryConfiguration cfg : kind.forJob(build.getParent(), libraryVersions)) {
                String name = cfg.getName();
                if (!cfg.isImplicit() && !libraryVersions.containsKey(name)) continue;
                if (librariesAdded.containsKey(name)) {
                    listener.getLogger().println("Only using first definition of library " + name);
                    continue;
                }
                String version = cfg.defaultedVersion((String)libraryVersions.remove(name));
                Boolean changelog = cfg.defaultedChangelogs((Boolean)libraryChangelogs.remove(name));
                String source = kind.getClass().getName();
                if (cfg instanceof LibraryResolver.ResolvedLibraryConfiguration) {
                    source = ((LibraryResolver.ResolvedLibraryConfiguration)cfg).getSource();
                }
                LibraryRetriever retriever = cfg.getRetriever();
                String libraryPath = null;
                if (retriever instanceof SCMBasedRetriever) {
                    libraryPath = ((SCMBasedRetriever)retriever).getLibraryPath();
                }
                librariesAdded.put(name, new LibraryRecord(name, version, kindTrusted, changelog, cfg.getCachingConfiguration(), source, libraryPath));
                retrievers.put(name, retriever);
            }
        }
        for (String name : librariesAdded.keySet()) {
            String unparsed = (String)librariesUnparsed.get(name);
            if (unparsed == null) continue;
            libraries.remove(unparsed);
        }
        build.addAction((Action)new LibrariesAction(new ArrayList<LibraryRecord>(librariesAdded.values())));
        for (LibraryRecord record : librariesAdded.values()) {
            listener.getLogger().println("Loading library " + record.getLogString());
            for (URL u : LibraryAdder.retrieve(record, (LibraryRetriever)((Object)retrievers.get(record.name)), listener, build, execution)) {
                additions.add(new ClasspathAdder.Addition(u, record.trusted));
            }
        }
        return additions;
    }

    @NonNull
    static String[] parse(@NonNull String identifier) {
        int at = identifier.indexOf(64);
        if (at == -1) {
            return new String[]{identifier, null};
        }
        return new String[]{identifier.substring(0, at), identifier.substring(at + 1)};
    }

    private static CacheStatus getCacheStatus(@NonNull LibraryCachingConfiguration cachingConfiguration, @NonNull FilePath versionCacheDir) throws IOException, InterruptedException {
        if (cachingConfiguration.isRefreshEnabled().booleanValue()) {
            long cachingMilliseconds = cachingConfiguration.getRefreshTimeMilliseconds();
            if (versionCacheDir.exists()) {
                if (versionCacheDir.lastModified() + cachingMilliseconds > System.currentTimeMillis()) {
                    if (LibraryAdder.getUrlsForLibDir(versionCacheDir).isEmpty()) {
                        return CacheStatus.EMPTY;
                    }
                    return CacheStatus.VALID;
                }
                return CacheStatus.EXPIRED;
            }
            return CacheStatus.DOES_NOT_EXIST;
        }
        if (versionCacheDir.exists()) {
            if (LibraryAdder.getUrlsForLibDir(versionCacheDir).isEmpty()) {
                return CacheStatus.EMPTY;
            }
            return CacheStatus.VALID;
        }
        return CacheStatus.DOES_NOT_EXIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<URL> retrieve(@NonNull LibraryRecord record, @NonNull LibraryRetriever retriever, @NonNull TaskListener listener, @NonNull Run<?, ?> run, @NonNull CpsFlowExecution execution) throws Exception {
        List<URL> urls;
        String name = record.name;
        String version = record.version;
        boolean changelog = record.changelog;
        String libraryLogString = record.getLogString();
        LibraryCachingConfiguration cachingConfiguration = record.cachingConfiguration;
        FilePath libDir = new FilePath(execution.getOwner().getRootDir()).child("libs/" + record.getDirectoryName());
        Boolean shouldCache = cachingConfiguration != null;
        FilePath versionCacheDir = new FilePath(LibraryCachingConfiguration.getGlobalLibrariesCacheDir(), record.getDirectoryName());
        ReentrantReadWriteLock retrieveLock = LibraryAdder.getReadWriteLockFor(record.getDirectoryName());
        FilePath lastReadFile = new FilePath(versionCacheDir, "last_read");
        if (shouldCache.booleanValue() && cachingConfiguration.isExcluded(version).booleanValue()) {
            listener.getLogger().println("Library " + libraryLogString + " is excluded from caching.");
            shouldCache = false;
        }
        if (shouldCache.booleanValue() && cachingConfiguration.isIncluded(version).booleanValue() || shouldCache.booleanValue() && StringUtils.isBlank((String)cachingConfiguration.getIncludedVersionsStr())) {
            retrieveLock.readLock().lockInterruptibly();
            try {
                CacheStatus cacheStatus = LibraryAdder.getCacheStatus(cachingConfiguration, versionCacheDir);
                if (cacheStatus == CacheStatus.DOES_NOT_EXIST || cacheStatus == CacheStatus.EXPIRED || cacheStatus == CacheStatus.EMPTY) {
                    retrieveLock.readLock().unlock();
                    retrieveLock.writeLock().lockInterruptibly();
                    try {
                        boolean retrieve = false;
                        switch (LibraryAdder.getCacheStatus(cachingConfiguration, versionCacheDir)) {
                            case VALID: {
                                listener.getLogger().println("Library " + libraryLogString + " is cached. Copying from cache.");
                                break;
                            }
                            case EMPTY: {
                                listener.getLogger().println("Library " + libraryLogString + " should have been cached but is empty, re-caching.");
                                LibraryAdder.deleteCacheDirIfExists(versionCacheDir);
                                retrieve = true;
                                break;
                            }
                            case DOES_NOT_EXIST: {
                                retrieve = true;
                                break;
                            }
                            case EXPIRED: {
                                long cachingMinutes = cachingConfiguration.getRefreshTimeMinutes();
                                listener.getLogger().println("Library " + libraryLogString + " is due for a refresh after " + cachingMinutes + " minutes, clearing.");
                                LibraryAdder.deleteCacheDirIfExists(versionCacheDir);
                                retrieve = true;
                            }
                        }
                        if (retrieve) {
                            listener.getLogger().println("Caching library " + libraryLogString);
                            versionCacheDir.mkdirs();
                            try {
                                retriever.retrieve(name, version, changelog, versionCacheDir, run, listener);
                                if (LibraryAdder.getUrlsForLibDir(versionCacheDir).isEmpty()) {
                                    String jobName = run.getParent().getFullName();
                                    String message = "Library " + libraryLogString + " is empty after retrieval in job " + jobName + ". Cleaning up cache directory.";
                                    listener.getLogger().println(message);
                                    LOGGER.log(Level.WARNING, message);
                                    LibraryAdder.deleteCacheDirIfExists(versionCacheDir);
                                    throw new AbortException("Library " + libraryLogString + " is empty.");
                                }
                                listener.getLogger().println("Library " + libraryLogString + " successfully cached.");
                            }
                            catch (Exception e) {
                                listener.getLogger().println("Failed to cache library " + libraryLogString + ". Error message: " + e.getMessage() + ". Cleaning up cache directory.");
                                LibraryAdder.deleteCacheDirIfExists(versionCacheDir);
                                throw e;
                            }
                        }
                        retrieveLock.readLock().lock();
                    }
                    finally {
                        retrieveLock.writeLock().unlock();
                    }
                }
                listener.getLogger().println("Library " + libraryLogString + " is cached. Copying from cache.");
                lastReadFile.touch(System.currentTimeMillis());
                versionCacheDir.withSuffix("-name.txt").write(name, "UTF-8");
                versionCacheDir.copyRecursiveTo(libDir);
            }
            finally {
                retrieveLock.readLock().unlock();
            }
        }
        retriever.retrieve(name, version, changelog, libDir, run, listener);
        libDir.withSuffix("-name.txt").write(name, "UTF-8");
        if (!record.trusted) {
            for (String clazz : ReplayAction.replacementsIn((CpsFlowExecution)execution)) {
                for (String root : new String[]{"src", "vars"}) {
                    String replacement;
                    String rel = root + "/" + clazz.replace('.', '/') + ".groovy";
                    FilePath f = libDir.child(rel);
                    if (!f.exists() || (replacement = ReplayAction.replace((CpsFlowExecution)execution, (String)clazz)) == null) continue;
                    listener.getLogger().println("Replacing contents of " + rel);
                    f.write(replacement, null);
                }
            }
        }
        if ((urls = LibraryAdder.getUrlsForLibDir(libDir, record)).isEmpty()) {
            throw new AbortException("Library " + name + " expected to contain at least one of src or vars directories");
        }
        return urls;
    }

    private static void deleteCacheDirIfExists(FilePath versionCacheDir) throws IOException, InterruptedException {
        if (versionCacheDir.exists()) {
            versionCacheDir.deleteRecursive();
            versionCacheDir.withSuffix("-name.txt").delete();
        }
    }

    private static List<URL> getUrlsForLibDir(FilePath libDir) throws MalformedURLException, IOException, InterruptedException {
        return LibraryAdder.getUrlsForLibDir(libDir, null);
    }

    private static List<URL> getUrlsForLibDir(FilePath libDir, LibraryRecord record) throws MalformedURLException, IOException, InterruptedException {
        FilePath varsDir;
        ArrayList<URL> urls = new ArrayList<URL>();
        FilePath srcDir = libDir.child("src");
        if (srcDir.isDirectory()) {
            urls.add(srcDir.toURI().toURL());
        }
        if ((varsDir = libDir.child("vars")).isDirectory()) {
            urls.add(varsDir.toURI().toURL());
            if (record != null) {
                for (FilePath var : varsDir.list("*.groovy")) {
                    record.variables.add(var.getBaseName());
                }
            }
        }
        return urls;
    }

    @NonNull
    static Map<String, String> findResources(@NonNull CpsFlowExecution execution, @NonNull String name, @CheckForNull String encoding) throws IOException, InterruptedException {
        Run run;
        LibrariesAction action;
        TreeMap<String, String> resources = new TreeMap<String, String>();
        Queue.Executable executable = execution.getOwner().getExecutable();
        if (executable instanceof Run && (action = (LibrariesAction)(run = (Run)executable).getAction(LibrariesAction.class)) != null) {
            FilePath libs = new FilePath(run.getRootDir()).child("libs");
            for (LibraryRecord library : action.getLibraries()) {
                FilePath libResources = libs.child(library.getDirectoryName() + "/resources/");
                FilePath f = libResources.child(name);
                if (!new File(f.getRemote()).getCanonicalFile().toPath().startsWith(new File(libResources.getRemote()).getCanonicalPath())) {
                    throw new AbortException(name + " references a file that is not contained within the library: " + library.name);
                }
                if (!f.exists()) continue;
                resources.put(library.name, LibraryAdder.readResource(f, encoding));
            }
        }
        return resources;
    }

    private static String readResource(FilePath file, @CheckForNull String encoding) throws IOException, InterruptedException {
        try (InputStream in = file.read();){
            if ("Base64".equals(encoding)) {
                String string = Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)in));
                return string;
            }
            String string = IOUtils.toString((InputStream)in, (String)encoding);
            return string;
        }
    }

    private static enum CacheStatus {
        VALID,
        EMPTY,
        DOES_NOT_EXIST,
        EXPIRED;

    }

    @Extension
    public static class Copier
    extends FlowCopier.ByRun {
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            LibrariesAction action = (LibrariesAction)original.getAction(LibrariesAction.class);
            if (action != null) {
                copy.addAction((Action)new LibrariesAction(action.getLibraries()));
                FilePath libs = new FilePath(original.getRootDir()).child("libs");
                if (libs.isDirectory()) {
                    libs.copyRecursiveTo(new FilePath(copy.getRootDir()).child("libs"));
                }
            }
        }
    }

    @Extension
    public static class LoadedLibraries
    extends OriginalLoadedScripts {
        public Map<String, String> loadScripts(CpsFlowExecution execution) {
            HashMap<String, String> scripts = new HashMap<String, String>();
            try {
                Run run;
                LibrariesAction action;
                Queue.Executable executable = execution.getOwner().getExecutable();
                if (executable instanceof Run && (action = (LibrariesAction)(run = (Run)executable).getAction(LibrariesAction.class)) != null) {
                    FilePath libs = new FilePath(run.getRootDir()).child("libs");
                    for (LibraryRecord library : action.getLibraries()) {
                        if (library.trusted) continue;
                        for (String rootName : new String[]{"src", "vars"}) {
                            FilePath root = libs.child(library.getDirectoryName() + "/" + rootName);
                            if (!root.isDirectory()) continue;
                            for (FilePath groovy : root.list("**/*.groovy")) {
                                String clazz = LoadedLibraries.className(groovy.getRemote(), root.getRemote());
                                scripts.put(clazz, groovy.readToString());
                            }
                        }
                    }
                }
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            return scripts;
        }

        static String className(String groovy, String root) {
            return groovy.replaceFirst("^" + Pattern.quote(root) + "[/\\\\](.+)[.]groovy", "$1").replace('/', '.').replace('\\', '.');
        }
    }

    @Extension
    public static class GlobalVars
    extends GlobalVariableSet {
        public Collection<GlobalVariable> forRun(Run<?, ?> run) {
            if (run == null) {
                return Collections.emptySet();
            }
            LibrariesAction action = (LibrariesAction)run.getAction(LibrariesAction.class);
            if (action == null) {
                return Collections.emptySet();
            }
            ArrayList<GlobalVariable> vars = new ArrayList<GlobalVariable>();
            for (LibraryRecord library : action.getLibraries()) {
                for (String variable : library.variables) {
                    vars.add(new UserDefinedGlobalVariable(variable, new File(run.getRootDir(), "libs/" + library.getDirectoryName() + "/vars/" + variable + ".txt")));
                }
            }
            return vars;
        }
    }
}

