/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.cards.items;

import hudson.Util;
import io.jenkins.plugins.pipelinegraphview.Messages;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jenkins.metrics.impl.TimeInQueueAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class TimingRunDetailsItems {
    public static List<RunDetailsItem> get(WorkflowRun run) {
        ArrayList<RunDetailsItem> runDetailsItems = new ArrayList<RunDetailsItem>();
        long startedTime = Math.abs(run.getTime().getTime() - new Date().getTime());
        RunDetailsItem.RunDetail startedItem = new RunDetailsItem.RunDetail(new RunDetailsItem.Icon.Ionicon("time-outline"), RunDetailsItem.ItemContent.of(Messages.startedAgo(Util.getTimeSpanString((long)startedTime))));
        runDetailsItems.add(startedItem);
        TimeInQueueAction timeInQueueAction = (TimeInQueueAction)run.getAction(TimeInQueueAction.class);
        if (timeInQueueAction != null) {
            RunDetailsItem.RunDetail queuedItem = new RunDetailsItem.RunDetail(new RunDetailsItem.Icon.Ionicon("hourglass-outline"), RunDetailsItem.ItemContent.of(Messages.queued(Util.getTimeSpanString((long)timeInQueueAction.getQueuingDurationMillis()))));
            runDetailsItems.add(queuedItem);
        }
        RunDetailsItem.RunDetail timerItem = new RunDetailsItem.RunDetail(new RunDetailsItem.Icon.Ionicon("timer-outline"), RunDetailsItem.ItemContent.of(Messages.took(run.getDurationString())));
        runDetailsItems.add(timerItem);
        return runDetailsItems;
    }
}

