/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import hudson.Util;
import hudson.model.Cause;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.agent_build_history.Messages;
import io.jenkins.plugins.agent_build_history.Utils;
import java.util.ArrayList;
import java.util.List;
import jenkins.console.ConsoleUrlProvider;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.actions.ArgumentsActionImpl;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class WorkflowJobTrend {
    private final List<WorkflowRunResult> results = new ArrayList<WorkflowRunResult>();
    private final String agentFilter;
    private final boolean filterByAgent;
    private int startNewer;
    private int startOlder;
    private int oldestBuild;
    private int newestBuild;
    private int startBuild;
    private boolean hasMoreRuns = false;
    private final WorkflowJob job;
    private final int limit;
    private final String statusFilter;

    public WorkflowJobTrend(WorkflowJob job, String statusFilter, String agentFilter, int startBuild, int limit) {
        this.agentFilter = agentFilter;
        this.job = job;
        this.filterByAgent = Util.fixEmptyAndTrim((String)agentFilter) != null;
        this.startBuild = startBuild;
        this.limit = limit;
        this.statusFilter = statusFilter;
    }

    void compute() {
        WorkflowRun lastRun = this.job.getLastBuild();
        if (lastRun != null) {
            WorkflowRun n;
            WorkflowRun firstRun = this.job.getFirstBuild();
            this.newestBuild = lastRun.getNumber();
            if (this.startBuild == -1) {
                this.startBuild = this.newestBuild;
            }
            if (this.startBuild < this.limit) {
                this.startBuild = this.limit;
            }
            if (this.startBuild > this.newestBuild) {
                this.startBuild = this.newestBuild;
            }
            int endBuild = this.startBuild;
            int i = 0;
            for (n = this.job.getNearestBuild(this.startBuild); n != null && i < this.limit; n = n.getPreviousBuild()) {
                WorkflowRunResult result;
                if (Utils.includeRun(n.getResult(), this.statusFilter) && (result = this.calculate(n)) != null) {
                    this.results.add(result);
                    ++i;
                }
                endBuild = n.getNumber() - 1;
            }
            this.startOlder = endBuild;
            this.oldestBuild = 0;
            if (firstRun != null) {
                this.oldestBuild = firstRun.getNumber();
            }
            this.oldestBuild += this.limit - 1;
            this.startNewer = this.startBuild + this.limit;
            if (this.startNewer > this.newestBuild) {
                this.startNewer = this.newestBuild;
            }
            this.hasMoreRuns = n != null;
        } else {
            this.startOlder = -1;
            this.startNewer = Integer.MAX_VALUE;
            this.oldestBuild = -1;
            this.newestBuild = -1;
        }
    }

    @Exported
    public WorkflowJob getJob() {
        return this.job;
    }

    @Exported
    public String getFullName() {
        return this.job.getFullName();
    }

    public int getStartNewer() {
        return this.startNewer;
    }

    public int getStartOlder() {
        return this.startOlder;
    }

    public int getOldestBuild() {
        return this.oldestBuild;
    }

    public int getNewestBuild() {
        return this.newestBuild;
    }

    public int getStartBuild() {
        return this.startBuild;
    }

    public boolean isHasMoreRuns() {
        return this.hasMoreRuns;
    }

    @Exported(visibility=999, name="runs")
    public List<WorkflowRunResult> getResults() throws Exception {
        return this.results;
    }

    @SuppressRestrictedWarnings(value={ArgumentsActionImpl.class, hudson.model.Messages.class})
    private WorkflowRunResult calculate(WorkflowRun run) {
        boolean include;
        WorkflowRunResult result = new WorkflowRunResult(run);
        FlowExecution flowExecution = run.getExecution();
        boolean bl = include = !this.filterByAgent;
        if (flowExecution != null) {
            for (FlowNode flowNode : new DepthFirstScanner().allNodes(flowExecution)) {
                StepStartNode startNode;
                StepDescriptor descriptor;
                if (!(flowNode instanceof StepStartNode) || !((descriptor = (startNode = (StepStartNode)flowNode).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || flowNode.getActions(BodyInvocationAction.class).isEmpty()) continue;
                for (FlowNode parent : flowNode.getParents()) {
                    String label;
                    WorkspaceActionImpl action;
                    StepStartNode parentNode;
                    StepDescriptor parentDescriptor;
                    if (!(parent instanceof StepStartNode) || !((parentDescriptor = (parentNode = (StepStartNode)parent).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || (action = (WorkspaceActionImpl)parentNode.getAction(WorkspaceActionImpl.class)) == null) continue;
                    NodeExecution nodeExecution = new NodeExecution();
                    String nodeName = action.getNode();
                    if (nodeName.isEmpty()) {
                        if (this.filterByAgent && this.agentFilter.equals("built-in")) {
                            include = true;
                        }
                        nodeExecution.builtOn = "(built-in)";
                        nodeExecution.builtOnStr = hudson.model.Messages.Hudson_Computer_DisplayName();
                    } else {
                        Node node = Jenkins.get().getNode(nodeName);
                        if (node != null) {
                            if (this.filterByAgent && this.agentFilter.equals(node.getNodeName())) {
                                include = true;
                            }
                            nodeExecution.builtOn = node.getNodeName();
                            nodeExecution.builtOnStr = node.getDisplayName();
                        } else {
                            if (this.filterByAgent && this.agentFilter.equals(nodeName)) {
                                include = true;
                            }
                            nodeExecution.builtOnStr = nodeName;
                        }
                    }
                    BlockEndNode endNode = startNode.getEndNode();
                    nodeExecution.agentDuration = this.getAgentDuration((BlockStartNode)startNode, endNode);
                    ArgumentsActionImpl args = (ArgumentsActionImpl)parentNode.getAction(ArgumentsActionImpl.class);
                    if (args != null && (label = (String)args.getArgumentValue("label")) != null) {
                        nodeExecution.label = label;
                    }
                    result.addNodeExecution(nodeExecution);
                }
            }
        }
        if (include) {
            return result;
        }
        return null;
    }

    public AgentDuration getAgentDuration(BlockStartNode startNode, BlockEndNode endNode) {
        TimingAction endTime;
        TimingAction startTime = (TimingAction)startNode.getAction(TimingAction.class);
        if (startTime == null) {
            return null;
        }
        long endTimeLong = 0L;
        if (endNode != null && (endTime = (TimingAction)endNode.getAction(TimingAction.class)) != null) {
            endTimeLong = endTime.getStartTime();
        }
        return new AgentDuration(startTime.getStartTime(), endTimeLong);
    }

    @ExportedBean(defaultVisibility=2)
    public static class WorkflowRunResult {
        private final WorkflowRun run;
        private List<NodeExecution> agents = new ArrayList<NodeExecution>();

        private WorkflowRunResult(WorkflowRun run) {
            this.run = run;
        }

        public void addNodeExecution(NodeExecution exec) {
            this.agents.add(exec);
        }

        @Exported(visibility=999, name="build")
        public WorkflowRun getRun() {
            return this.run;
        }

        @Exported(visibility=999, name="agents")
        public List<NodeExecution> getAgents() {
            return this.agents;
        }

        public String getConsoleUrl() {
            return ConsoleUrlProvider.getRedirectUrl((Run)this.run);
        }

        @Exported(name="cause")
        public String getShortDescription() {
            List causeList = this.run.getCauses();
            if (!causeList.isEmpty()) {
                return ((Cause)causeList.get(causeList.size() - 1)).getShortDescription();
            }
            return "Unknown Cause";
        }

        @Exported
        public Result getResult() {
            return this.run.getResult();
        }
    }

    @ExportedBean(defaultVisibility=3)
    public static class NodeExecution {
        private String builtOn;
        private String builtOnStr;
        private String label;
        private AgentDuration agentDuration;

        @Exported
        public String getBuiltOn() {
            return this.builtOn;
        }

        public String getBuiltOnStr() {
            return this.builtOnStr;
        }

        public String getDurationString() {
            if (this.agentDuration == null) {
                return "n/a";
            }
            return this.agentDuration.getDurationString();
        }

        @Exported
        public long getDuration() {
            if (this.agentDuration == null) {
                return 0L;
            }
            return this.agentDuration.getEndTime() - this.agentDuration.getStartTime();
        }

        @Exported
        public String getLabel() {
            return this.label;
        }

        @Exported
        public long getStartTime() {
            if (this.agentDuration == null) {
                return 0L;
            }
            return this.agentDuration.getStartTime();
        }
    }

    public static class AgentDuration {
        private final long startTime;
        private final long endTime;

        public AgentDuration(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getDurationString() {
            if (this.endTime == 0L) {
                return Messages.InProgressDuration(Util.getTimeSpanString((long)(System.currentTimeMillis() - this.startTime)));
            }
            return Util.getTimeSpanString((long)(this.endTime - this.startTime));
        }
    }
}

