/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import hudson.model.Result;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuildHistoryFileManager {
    private static final Logger LOGGER = Logger.getLogger(BuildHistoryFileManager.class.getName());
    public static final String separator = ";";
    private static final Map<String, Object> nodeLocks = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getNodeLock(String nodeName) {
        Map<String, Object> map = nodeLocks;
        synchronized (map) {
            return nodeLocks.computeIfAbsent(nodeName, k -> new Object());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readIndexFile(String nodeName, String storageDir) {
        Object lock;
        Object object = lock = BuildHistoryFileManager.getNodeLock(nodeName);
        synchronized (object) {
            ArrayList<String> indexLines = new ArrayList<String>();
            File indexFile = new File(storageDir + "/" + nodeName + "_index.txt");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(indexFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    indexLines.add(line);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.INFO, "Index file not found for node " + nodeName);
                return Collections.emptyList();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read index file for node " + nodeName, e);
                return Collections.emptyList();
            }
            return indexLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateResult(String nodeName, Run<?, ?> run, String storageDir) {
        Object lock = BuildHistoryFileManager.getNodeLock(nodeName);
        String runIdentifier = run.getParent().getFullName() + separator + run.getNumber() + separator;
        Object object = lock;
        synchronized (object) {
            block20: {
                List<String> indexLines = BuildHistoryFileManager.readIndexFile(nodeName, storageDir);
                StringWriter buffer = new StringWriter();
                try (BufferedWriter writer = new BufferedWriter(buffer);){
                    boolean found = false;
                    for (String line : indexLines) {
                        if (line.startsWith(runIdentifier)) {
                            if (!line.endsWith(separator + String.valueOf(run.getResult()))) {
                                BuildHistoryFileManager.writeLine(writer, run);
                                found = true;
                            } else {
                                writer.write(line);
                            }
                        } else {
                            writer.write(line);
                        }
                        writer.newLine();
                    }
                    if (!found) break block20;
                    writer.flush();
                    File indexFile = new File(storageDir + "/" + nodeName + "_index.txt");
                    try (FileWriter fileWriter = new FileWriter(indexFile, StandardCharsets.UTF_8);){
                        fileWriter.write(buffer.toString());
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to update result in index-file for node " + nodeName, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunToNodeIndex(String nodeName, Run<?, ?> run, String storageDir) {
        Object lock;
        Object object = lock = BuildHistoryFileManager.getNodeLock(nodeName);
        synchronized (object) {
            File indexFile = new File(storageDir + "/" + nodeName + "_index.txt");
            List<String> lines = BuildHistoryFileManager.readIndexFile(nodeName, storageDir);
            String lineMatch = run.getParent().getFullName() + separator + run.getNumber() + separator;
            boolean exists = lines.stream().anyMatch(line -> line.startsWith(lineMatch));
            if (!exists) {
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile, true), StandardCharsets.UTF_8));){
                    BuildHistoryFileManager.writeLine(writer, run);
                    writer.newLine();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to update index for node " + nodeName, e);
                }
            }
        }
    }

    private static void writeLine(BufferedWriter writer, Run<?, ?> run) throws IOException {
        Result result;
        writer.write(run.getParent().getFullName() + separator + run.getNumber() + separator + run.getStartTimeInMillis());
        if (!run.isLogUpdated() && (result = run.getResult()) != null) {
            writer.write(separator + result.toString());
        }
    }

    public static Set<String> getAllSavedNodeNames(String storageDir) {
        HashSet<String> nodeNames = new HashSet<String>();
        File storageDirectory = new File(storageDir);
        File[] files = storageDirectory.listFiles((dir, name) -> name.endsWith("_index.txt"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                String nodeName = fileName.substring(0, fileName.length() - "_index.txt".length());
                nodeNames.add(nodeName);
            }
        }
        return nodeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteExecution(String nodeName, String jobName, int buildNumber, String storageDir) {
        Object lock = BuildHistoryFileManager.getNodeLock(nodeName);
        String runIdentifier = jobName + separator + buildNumber + separator;
        Object object = lock;
        synchronized (object) {
            List<String> indexLines = BuildHistoryFileManager.readIndexFile(nodeName, storageDir);
            File indexFile = new File(storageDir + "/" + nodeName + "_index.txt");
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), StandardCharsets.UTF_8));){
                for (String line : indexLines) {
                    if (line.startsWith(runIdentifier)) continue;
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to delete Execution for Node: " + nodeName + " job: " + jobName + " build: " + buildNumber, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteJobSerialization(String jobName, String storageDir) {
        Set<String> nodeNames = BuildHistoryFileManager.getAllSavedNodeNames(storageDir);
        for (String nodeName : nodeNames) {
            Object lock;
            Object object = lock = BuildHistoryFileManager.getNodeLock(nodeName);
            synchronized (object) {
                List<String> indexLines = BuildHistoryFileManager.readIndexFile(nodeName, storageDir);
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(storageDir + "/" + nodeName + "_index.txt"), StandardCharsets.UTF_8));){
                    for (String line : indexLines) {
                        if (line.startsWith(jobName + separator)) continue;
                        writer.write(line);
                        writer.newLine();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to delete job from index-file for job: " + jobName + ", node: " + nodeName, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteNodeSerializations(String nodeName, String storageDir) {
        Object lock;
        Object object = lock = BuildHistoryFileManager.getNodeLock(nodeName);
        synchronized (object) {
            File indexFile = new File(storageDir + "/" + nodeName + "_index.txt");
            if (indexFile.exists() && !indexFile.delete()) {
                LOGGER.log(Level.WARNING, "Failed to delete index file for node: " + nodeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameNodeFiles(String oldNodeName, String newNodeName, String storageDir) {
        Object lock;
        Object object = lock = BuildHistoryFileManager.getNodeLock(oldNodeName);
        synchronized (object) {
            File oldIndexFile = new File(storageDir + "/" + oldNodeName + "_index.txt");
            File newIndexFile = new File(storageDir + "/" + newNodeName + "_index.txt");
            if (oldIndexFile.exists() && !oldIndexFile.renameTo(newIndexFile)) {
                LOGGER.log(Level.WARNING, "Failed to rename index file from: " + oldNodeName + " to: " + newNodeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameJob(String oldFullName, String newFullName, String storageDir) {
        Set<String> nodeNames = BuildHistoryFileManager.getAllSavedNodeNames(storageDir);
        for (String nodeName : nodeNames) {
            Object lock;
            Object object = lock = BuildHistoryFileManager.getNodeLock(nodeName);
            synchronized (object) {
                List<String> indexLines = BuildHistoryFileManager.readIndexFile(nodeName, storageDir);
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(storageDir + "/" + nodeName + "_index.txt"), StandardCharsets.UTF_8));){
                    for (String line : indexLines) {
                        if (line.startsWith(oldFullName + separator)) {
                            writer.write(newFullName + line.substring(oldFullName.length()));
                            writer.newLine();
                            continue;
                        }
                        writer.write(line);
                        writer.newLine();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to rename jobs in index-file in node: " + nodeName, e);
                }
            }
        }
    }
}

