/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import hudson.Extension;
import io.jenkins.plugins.agent_build_history.AgentBuildHistory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class AgentBuildHistoryConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AgentBuildHistoryConfig.class.getName());
    private String storageDir = this.getDefaultStorageDir();

    public AgentBuildHistoryConfig() {
        this.load();
        this.ensureStorageDir();
    }

    private String getDefaultStorageDir() {
        String jenkinsRootDir = Jenkins.get().getRootDir().getAbsolutePath();
        return jenkinsRootDir + File.separator + "io.jenkins.plugins.agent_build_history.serialized_data";
    }

    private void ensureStorageDir() {
        File storageDirectory = new File(this.storageDir);
        if (!storageDirectory.exists()) {
            LOGGER.info("Creating storage directory at " + this.storageDir);
            try {
                boolean created = storageDirectory.mkdirs();
                if (!created) {
                    LOGGER.severe("Failed to create storage directory at " + this.storageDir);
                }
            }
            catch (SecurityException e) {
                LOGGER.log(Level.SEVERE, "SecurityException: Insufficient permissions to create directory at " + this.storageDir, e);
            }
        } else {
            LOGGER.info("Storage directory already exists at " + this.storageDir);
        }
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    @DataBoundSetter
    public void setStorageDir(String storageDir) {
        if (!this.storageDir.equals(storageDir)) {
            LOGGER.info("Changing storage directory from " + this.storageDir + " to " + storageDir);
            this.storageDir = storageDir;
            this.ensureStorageDir();
            AgentBuildHistory.setLoaded(false);
            this.save();
        }
    }

    public static AgentBuildHistoryConfig get() {
        return (AgentBuildHistoryConfig)((Object)GlobalConfiguration.all().get(AgentBuildHistoryConfig.class));
    }
}

