/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.agent_build_history.AgentBuildHistory;
import io.jenkins.plugins.agent_build_history.AgentBuildHistoryConfig;
import io.jenkins.plugins.agent_build_history.BuildHistoryFileManager;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.NodeListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class AgentBuildHistoryListeners {
    private static final Logger LOGGER = Logger.getLogger(AgentBuildHistoryListeners.class.getName());

    @Extension
    public static class AgentBuildHistoryExecutorListener
    implements ExecutorListener {
        public void taskStarted(Executor executor, Queue.Task task) {
            Queue.Executable executable = executor.getCurrentExecutable();
            Computer c = executor.getOwner();
            if (executable instanceof Run) {
                Run run = (Run)executable;
                LOGGER.log(Level.FINER, () -> "Starting Job: " + run.getFullDisplayName() + " on " + c.getName());
                AgentBuildHistory.startJobExecution(c, run);
            } else if (task instanceof ExecutorStepExecution.PlaceholderTask) {
                ExecutorStepExecution.PlaceholderTask pht = (ExecutorStepExecution.PlaceholderTask)task;
                executable = task.getOwnerExecutable();
                try {
                    FlowNode node = pht.getNode();
                    if (node != null && executable instanceof WorkflowRun) {
                        WorkflowRun run = (WorkflowRun)executable;
                        AgentBuildHistory.startFlowNodeExecution(c, run, node);
                        LOGGER.log(Level.FINER, () -> "Starting part of pipeline: " + run.getFullDisplayName() + " Node id: " + node.getId() + " on " + c.getName());
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Failed to get FlowNode");
                }
            }
        }
    }

    @Extension
    public static class HistoryNodeListener
    extends NodeListener {
        protected void onDeleted(@NonNull Node node) {
            String nodeName = node.getNodeName();
            BuildHistoryFileManager.deleteNodeSerializations(nodeName, AgentBuildHistoryConfig.get().getStorageDir());
        }

        protected void onUpdated(@NonNull Node oldOne, @NonNull Node newOne) {
            String newNodeName;
            String oldNodeName = oldOne.getNodeName();
            if (!oldNodeName.equals(newNodeName = newOne.getNodeName())) {
                BuildHistoryFileManager.renameNodeFiles(oldNodeName, newNodeName, AgentBuildHistoryConfig.get().getStorageDir());
            }
        }
    }

    @Extension
    public static class HistoryItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            if (item instanceof Job) {
                String jobName = item.getFullName();
                BuildHistoryFileManager.deleteJobSerialization(jobName, AgentBuildHistoryConfig.get().getStorageDir());
            }
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (item instanceof Job) {
                LOGGER.finer("Job renamed from " + oldFullName + " to " + newFullName);
                BuildHistoryFileManager.renameJob(oldFullName, newFullName, AgentBuildHistoryConfig.get().getStorageDir());
            }
        }
    }

    @Extension
    public static class HistoryRunListener
    extends RunListener<Run<?, ?>> {
        public void onDeleted(Run run) {
            String jobName = run.getParent().getFullName();
            int buildNumber = run.getNumber();
            Set<String> nodeNames = BuildHistoryFileManager.getAllSavedNodeNames(AgentBuildHistoryConfig.get().getStorageDir());
            for (String nodeName : nodeNames) {
                BuildHistoryFileManager.deleteExecution(nodeName, jobName, buildNumber, AgentBuildHistoryConfig.get().getStorageDir());
            }
        }

        public void onFinalized(Run<?, ?> run) {
            Set<String> nodeNames = BuildHistoryFileManager.getAllSavedNodeNames(AgentBuildHistoryConfig.get().getStorageDir());
            for (String nodeName : nodeNames) {
                BuildHistoryFileManager.updateResult(nodeName, run, AgentBuildHistoryConfig.get().getStorageDir());
            }
        }
    }
}

