/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.kohsuke.stapler.DataBoundConstructor;

public class LocustParser
extends AbstractParser {
    public LocustParser(String glob, String percentiles) {
        super(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public LocustParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = this.createPerformanceReport();
        report.setReportFileName(reportFile.getName());
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setShowTrendGraphs(this.showTrendGraphs);
        List<CSVRecord> reportData = this.getCsvData(reportFile);
        Date now = new Date();
        for (CSVRecord record : reportData) {
            String name = record.get(ReportColumns.Name.getColumn());
            long average = Double.valueOf(record.get(ReportColumns.Average.getColumn())).longValue();
            long min = Double.valueOf(record.get(ReportColumns.Min.getColumn())).longValue();
            long max = Double.valueOf(record.get(ReportColumns.Max.getColumn())).longValue();
            long failures = Double.valueOf(record.get(ReportColumns.Failures.getColumn())).longValue();
            long success = Double.valueOf(record.get(ReportColumns.Requests.getColumn())).longValue();
            long errors = (long)((double)failures / (double)success);
            long avgContentSize = Double.valueOf(record.get(ReportColumns.AvgContentSize.getColumn())).longValue();
            if (name.equals("Aggregated")) {
                report.setSummarizerSize(reportData.size() - 1);
                report.setSummarizerAvg(average);
                report.setSummarizerMin(min);
                report.setSummarizerMax(max);
                report.setSummarizerErrors(Float.toString(errors));
                continue;
            }
            HttpSample sample = new HttpSample();
            sample.setSuccessful(failures == 0L);
            sample.setSummarizer(true);
            sample.setUri(name);
            sample.setSummarizerMax(max);
            sample.setSummarizerMin(min);
            sample.setDuration(average);
            sample.setSummarizerSamples(success);
            sample.setSummarizerErrors(errors);
            sample.setSizeInKb(avgContentSize * success);
            sample.setDate(now);
            report.addSample(sample);
        }
        return report;
    }

    List<CSVRecord> getCsvData(File reportFile) {
        List records = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(reportFile), StandardCharsets.UTF_8));
             CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).build());){
            records = csvParser.getRecords();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return records;
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*_stats.csv";
    }

    static enum ReportColumns {
        Type(0),
        Name(1),
        Requests(2),
        Failures(3),
        Median(4),
        Average(5),
        Min(6),
        Max(7),
        AvgContentSize(8),
        Rps(9);

        int column;

        private ReportColumns(int order) {
            this.column = order;
        }

        int getColumn() {
            return this.column;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "Locust";
        }
    }
}

