/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.kohsuke.stapler.DataBoundConstructor;

public class JMeterCsvParser
extends AbstractParser {
    public char delimiter;
    public int timestampIdx = -1;
    public int elapsedIdx = -1;
    public int responseCodeIdx = -1;
    public int successIdx = -1;
    public int urlIdx = -1;
    public int bytesIdx = -1;
    public int sentBytesIdx = -1;

    public JMeterCsvParser(String glob, String percentiles) {
        this(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public JMeterCsvParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.csv";
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        this.clearDateFormat();
        PerformanceReport report = this.createPerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setShowTrendGraphs(this.showTrendGraphs);
        report.setReportFileName(reportFile.getName());
        String[] header = null;
        try (FileReader fr = new FileReader(reportFile, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(fr);){
            String line = reader.readLine();
            if (line != null) {
                header = this.readCSVHeader(line);
            }
        }
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(reportFile), StandardCharsets.UTF_8);){
            this.parseCSV(fileReader, header, report);
        }
        return report;
    }

    protected void parseCSV(Reader in, String[] header, PerformanceReport report) throws IOException {
        CSVFormat csvFormat = CSVFormat.Builder.create().setDelimiter(this.delimiter).setHeader(header).setQuote('\"').setSkipHeaderRecord(true).build();
        CSVParser records = csvFormat.parse(in);
        for (CSVRecord record : records) {
            HttpSample sample = this.getSample(record);
            report.addSample(sample);
        }
    }

    protected String[] readCSVHeader(String line) {
        this.delimiter = JMeterCsvParser.lookingForDelimiter(line);
        String[] header = line.split(String.valueOf(this.delimiter));
        for (int i = 0; i < header.length; ++i) {
            String field = header[i];
            if ("timestamp".equalsIgnoreCase(field)) {
                this.timestampIdx = i;
                continue;
            }
            if ("elapsed".equalsIgnoreCase(field)) {
                this.elapsedIdx = i;
                continue;
            }
            if ("responseCode".equalsIgnoreCase(field)) {
                this.responseCodeIdx = i;
                continue;
            }
            if ("success".equalsIgnoreCase(field)) {
                this.successIdx = i;
                continue;
            }
            if ("bytes".equalsIgnoreCase(field)) {
                this.bytesIdx = i;
                continue;
            }
            if ("sentBytes".equalsIgnoreCase(field)) {
                this.sentBytesIdx = i;
                continue;
            }
            if ("URL".equalsIgnoreCase(field) && this.urlIdx < 0) {
                this.urlIdx = i;
                continue;
            }
            if (!"label".equalsIgnoreCase(field) || this.urlIdx >= 0) continue;
            this.urlIdx = i;
        }
        if (this.timestampIdx < 0 || this.elapsedIdx < 0 || this.responseCodeIdx < 0 || this.successIdx < 0 || this.urlIdx < 0 || this.bytesIdx < 0) {
            throw new IllegalStateException("Missing required column");
        }
        return header;
    }

    protected static char lookingForDelimiter(String line) {
        for (char ch : line.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return ch;
        }
        throw new IllegalStateException("Cannot find delimiter in header " + line);
    }

    private HttpSample getSample(CSVRecord record) {
        HttpSample sample = new HttpSample();
        sample.setDate(this.parseTimestamp(record.get(this.timestampIdx)));
        sample.setDuration(Long.parseLong(record.get(this.elapsedIdx)));
        sample.setHttpCode(record.get(this.responseCodeIdx));
        sample.setSuccessful(Boolean.parseBoolean(record.get(this.successIdx)));
        long bytes = Long.parseLong(record.get(this.bytesIdx));
        if (this.sentBytesIdx != -1) {
            bytes += Long.parseLong(record.get(this.sentBytesIdx));
        }
        sample.setSizeInKb((double)bytes / 1024.0);
        sample.setUri(record.get(this.urlIdx));
        return sample;
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeterCSV";
        }
    }
}

