/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.data;

import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.reports.AbstractReport;

public abstract class ReportValueSelector {
    public abstract long getValue(AbstractReport var1);

    public abstract String getGraphType();

    public static ReportValueSelector get(Job<?, ?> job) {
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            return ReportValueSelector.get((PerformancePublisher)project.getPublishersList().get(PerformancePublisher.class));
        }
        return ReportValueSelector.get((PerformancePublisher)null);
    }

    public static ReportValueSelector get(PerformancePublisher publisher) {
        if (publisher == null) {
            return new SelectAverage();
        }
        String graphType = publisher.getGraphType();
        if (graphType == null) {
            return new SelectAverage();
        }
        if (graphType.equals("MRT")) {
            return new SelectMedian();
        }
        if (graphType.equals("PRT")) {
            return new SelectPercentile();
        }
        return new SelectAverage();
    }

    private static class SelectAverage
    extends ReportValueSelector {
        private SelectAverage() {
        }

        @Override
        public long getValue(AbstractReport report) {
            return report.getAverage();
        }

        @Override
        public String getGraphType() {
            return "ART";
        }
    }

    private static class SelectMedian
    extends ReportValueSelector {
        private SelectMedian() {
        }

        @Override
        public long getValue(AbstractReport report) {
            return report.getMedian();
        }

        @Override
        public String getGraphType() {
            return "MRT";
        }
    }

    private static class SelectPercentile
    extends ReportValueSelector {
        private SelectPercentile() {
        }

        @Override
        public long getValue(AbstractReport report) {
            return report.get90Line();
        }

        @Override
        public String getGraphType() {
            return "PRT";
        }
    }
}

