/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.InvisibleAction;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.jenkinsci.plugins.parallel_test_executor.ParallelTestExecutor;

class TestCollector
extends InvisibleAction
implements Serializable {
    private static final long serialVersionUID = -592264249944063364L;
    private final transient AbstractBuild<?, ?> collector;
    private final transient ParallelTestExecutor testExecutor;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed after initial use")
    private final transient int ordinal;

    public TestCollector(AbstractBuild<?, ?> collector, ParallelTestExecutor testExecutor, int ordinal) {
        this.testExecutor = testExecutor;
        assert (collector != null);
        this.collector = collector;
        this.ordinal = ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(AbstractBuild<?, ?> build, TaskListener listener) {
        block10: {
            if (this.collector == null) {
                return;
            }
            try {
                listener.getLogger().println("Collecting test reports for the master build: " + ModelHyperlinkNote.encodeTo(this.collector));
                FilePath src = build.getWorkspace();
                if (src == null) {
                    return;
                }
                FilePath workspace = this.collector.getWorkspace();
                if (workspace == null) {
                    return;
                }
                final FilePath dst = workspace.child("test-splits/reports/" + this.ordinal);
                dst.mkdirs();
                final String includes = this.testExecutor.getTestReportFiles();
                if (src.getChannel() == dst.getChannel()) {
                    src.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Integer>(){
                        private static final long serialVersionUID = 1L;

                        public Integer invoke(File base, VirtualChannel channel) throws IOException {
                            if (!base.exists()) {
                                return 0;
                            }
                            assert (dst.getChannel() == null);
                            try {
                                class CopyImpl
                                extends Copy {
                                    private int copySize;

                                    public CopyImpl() {
                                        this.setProject(new Project());
                                    }

                                    protected void doFileOperations() {
                                        this.copySize = this.fileCopyMap.size();
                                        super.doFileOperations();
                                    }

                                    public int getNumCopied() {
                                        return this.copySize;
                                    }
                                }
                                CopyImpl copyTask = new CopyImpl();
                                copyTask.setTodir(new File(dst.getRemote()));
                                copyTask.addFileset(Util.createFileSet((File)base, (String)includes));
                                copyTask.setOverwrite(true);
                                copyTask.setIncludeEmptyDirs(false);
                                copyTask.setPreserveLastModified(true);
                                copyTask.execute();
                                return copyTask.getNumCopied();
                            }
                            catch (BuildException e) {
                                throw new IOException("Failed to copy " + String.valueOf(base) + "/" + includes + " to " + String.valueOf(dst), e);
                            }
                        }
                    });
                    break block10;
                }
                if (src.getChannel() == null || dst.getChannel() == null) {
                    src.copyRecursiveTo(includes, dst);
                    break block10;
                }
                File t = Util.createTempDir();
                FilePath tmp = new FilePath(t);
                try {
                    src.copyRecursiveTo(this.testExecutor.getTestReportFiles(), tmp);
                    tmp.copyRecursiveTo(dst);
                }
                finally {
                    Util.deleteRecursive((File)t);
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(listener.error("Failed to aggregate test reports for " + this.collector.getFullDisplayName()));
            }
        }
    }
}

