/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oss.symbols;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class OpenSourceSymbols {
    private static final Logger LOGGER = Logger.getLogger(OpenSourceSymbols.class.getName());
    private static final String SVG_FILE_ENDING = ".svg";
    private static final String IMAGES_SYMBOLS_PATH = "images/symbols/";
    private static final String API_PLUGIN = "oss-symbols-api";
    private static final String ICON_CLASS_NAME_PATTERN = "symbol-%s plugin-oss-symbols-api";
    private static final OpenSourceSymbols INSTANCE = new OpenSourceSymbols();
    private final Map<String, String> availableIcons = new ConcurrentSkipListMap<String, String>();

    private OpenSourceSymbols() {
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(IMAGES_SYMBOLS_PATH);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (!url.toExternalForm().contains(API_PLUGIN)) continue;
                URI uri = url.toURI();
                if ("jar".equals(uri.getScheme())) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                        this.collectIcons(fileSystem.getPath(IMAGES_SYMBOLS_PATH, new String[0]));
                        break;
                    }
                }
                this.collectIcons(Paths.get(uri));
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Unable to read available icons: Resource unavailable.", ex);
        }
    }

    private void collectIcons(Path path) throws IOException {
        try (Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);){
            stream.filter(icon -> icon.getFileName().toString().endsWith(SVG_FILE_ENDING)).forEach(icon -> {
                String fileName = icon.getFileName().toString();
                String iconName = fileName.substring(0, fileName.length() - SVG_FILE_ENDING.length());
                this.availableIcons.put(iconName, OpenSourceSymbols.getIconClassName(iconName));
            });
        }
    }

    public static String getIconClassName(String icon) {
        return String.format(ICON_CLASS_NAME_PATTERN, icon);
    }

    public static Map<String, String> getAvailableIcons() {
        return OpenSourceSymbols.INSTANCE.availableIcons;
    }
}

