/*
 * Decompiled with CFR 0.152.
 */
package land.oras.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import land.oras.exception.OrasException;
import org.jspecify.annotations.NullMarked;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

@NullMarked
public final class JsonUtils {
    private static final ObjectMapper jsonMapper = ((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_EMPTY))).build();

    private JsonUtils() {
    }

    public static String toJson(Object object) {
        try {
            return jsonMapper.writeValueAsString(object);
        }
        catch (JacksonException e) {
            throw new OrasException("Unable to convert object to JSON string", e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)jsonMapper.readValue(json, clazz);
        }
        catch (JacksonException e) {
            throw new OrasException("Unable to parse JSON string", e);
        }
    }

    public static <T> T fromJson(InputStream is, Class<T> clazz) {
        try {
            return (T)jsonMapper.readValue(is, clazz);
        }
        catch (JacksonException e) {
            throw new OrasException("Unable to parse JSON string", e);
        }
    }

    public static <T> T fromJson(Path path, Class<T> clazz) {
        try {
            return (T)jsonMapper.readValue(Files.readString(path, StandardCharsets.UTF_8), clazz);
        }
        catch (IOException e) {
            throw new OrasException("Unable to read JSON file due to IO error", e);
        }
        catch (JacksonException e) {
            throw new OrasException("Unable to parse JSON file", e);
        }
    }

    public static <T> T fromJson(Path path, Type type) {
        try {
            return (T)jsonMapper.readValue(Files.readString(path, StandardCharsets.UTF_8), jsonMapper.getTypeFactory().constructType(type));
        }
        catch (IOException e) {
            throw new OrasException("Unable to read JSON file due to IO error", e);
        }
        catch (JacksonException e) {
            throw new OrasException("Unable to parse JSON file", e);
        }
    }

    public static <T> T fromJson(Reader reader, Type type) {
        try {
            return (T)jsonMapper.readValue(reader, jsonMapper.getTypeFactory().constructType(type));
        }
        catch (JacksonException e) {
            throw new OrasException("Unable to parse JSON content", e);
        }
    }

    public static String readFile(Path path) {
        try {
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new OrasException("Unable to read file", e);
        }
    }
}

