/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import java.io.InputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import land.oras.ContainerRef;
import land.oras.OrasModel;
import land.oras.auth.AuthProvider;
import land.oras.auth.AuthScheme;
import land.oras.auth.Scope;
import land.oras.auth.Scopes;
import land.oras.exception.OrasException;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public final class HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static final Pattern WWW_AUTH_VALUE_PATTERN = Pattern.compile("Bearer realm=\"([^\"]+)\",service=\"([^\"]+)\",scope=\"([^\"]+)\"(,error=\"([^\"]+)\")?");
    private final HttpClient.Builder builder = java.net.http.HttpClient.newBuilder();
    private java.net.http.HttpClient client;
    private boolean skipTlsVerify;
    private Integer timeout;

    private HttpClient() {
        this.builder.followRedirects(HttpClient.Redirect.NEVER);
        this.skipTlsVerify = false;
        this.builder.cookieHandler(new CookieManager(null, CookiePolicy.ACCEPT_NONE));
        this.setTimeout(60);
    }

    private void setTimeout(@Nullable Integer timeout) {
        if (timeout != null) {
            this.timeout = timeout;
            this.builder.connectTimeout(Duration.ofSeconds(timeout.intValue()));
        }
    }

    private void setTlsVerify(boolean skipTlsVerify) {
        this.skipTlsVerify = skipTlsVerify;
        if (skipTlsVerify) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, new SecureRandom());
                this.builder.sslContext(sslContext);
            }
            catch (Exception e) {
                throw new OrasException("Unable to skip TLS verification", e);
            }
        }
    }

    public HttpClient build() {
        this.client = this.builder.build();
        return this;
    }

    public ResponseWrapper<String> get(URI uri, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("GET", uri, true, headers, new byte[0], HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.noBody(), scopes, authProvider);
    }

    public ResponseWrapper<Path> download(URI uri, Map<String, String> headers, Path file, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("GET", uri, true, headers, new byte[0], HttpResponse.BodyHandlers.ofFile(file), HttpRequest.BodyPublishers.noBody(), scopes, authProvider);
    }

    public ResponseWrapper<InputStream> download(URI uri, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("GET", uri, true, headers, new byte[0], HttpResponse.BodyHandlers.ofInputStream(), HttpRequest.BodyPublishers.noBody(), scopes, authProvider);
    }

    public ResponseWrapper<String> upload(String method, URI uri, Map<String, String> headers, Path file, Scopes scopes, AuthProvider authProvider) {
        try {
            return this.executeRequest(method, uri, true, headers, new byte[0], HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.ofFile(file), scopes, authProvider);
        }
        catch (Exception e) {
            throw new OrasException("Unable to upload file", e);
        }
    }

    public ResponseWrapper<String> head(URI uri, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("HEAD", uri, true, headers, new byte[0], HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.noBody(), scopes, authProvider);
    }

    public ResponseWrapper<String> delete(URI uri, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("DELETE", uri, true, headers, new byte[0], HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.noBody(), scopes, authProvider);
    }

    public ResponseWrapper<String> post(URI uri, byte[] body, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("POST", uri, true, headers, body, HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.ofByteArray(body), scopes, authProvider);
    }

    public ResponseWrapper<String> patch(URI uri, byte[] body, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("PATCH", uri, true, headers, body, HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.ofByteArray(body), scopes, authProvider);
    }

    public ResponseWrapper<String> put(URI uri, byte[] body, Map<String, String> headers, Scopes scopes, AuthProvider authProvider) {
        return this.executeRequest("PUT", uri, true, headers, body, HttpResponse.BodyHandlers.ofString(), HttpRequest.BodyPublishers.ofByteArray(body), scopes, authProvider);
    }

    public <T> TokenResponse refreshToken(ResponseWrapper<T> response, Scopes scopes, AuthProvider authProvider) {
        String wwwAuthHeader = response.headers().getOrDefault("WWW-Authenticate".toLowerCase(), "");
        LOG.debug("WWW-Authenticate header: {}", (Object)wwwAuthHeader);
        if (wwwAuthHeader.isEmpty()) {
            throw new OrasException("No WWW-Authenticate header found in response");
        }
        Matcher matcher = WWW_AUTH_VALUE_PATTERN.matcher(wwwAuthHeader);
        if (!matcher.matches()) {
            throw new OrasException("Invalid WWW-Authenticate header value: " + wwwAuthHeader);
        }
        String realm = matcher.group(1);
        String service = matcher.group(2);
        String scope = matcher.group(3);
        String error = matcher.group(5);
        Scopes newScopes = scopes.withNewScope(scope);
        LOG.debug("New scopes with server: {}", newScopes.getScopes());
        LOG.debug("WWW-Authenticate header: realm={}, service={}, scope={}, error={}", new Object[]{realm, service, scope, error});
        URI uri = URI.create(realm + "?scope=" + scope + "&service=" + service);
        HashMap<String, String> headers = new HashMap<String, String>();
        ResponseWrapper<String> responseWrapper = this.get(uri, headers, scopes, authProvider);
        LOG.debug("Response: {}", (Object)responseWrapper.response().replaceAll("\"token\"\\s*:\\s*\"([A-Za-z0-9\\-_\\.]+)\"", "\"token\":\"<redacted>\"").replaceAll("\"access_token\"\\s*:\\s*\"([A-Za-z0-9\\-_\\.]+)\"", "\"access_token\":\"<redacted>\""));
        LOG.debug("Headers: {}", responseWrapper.headers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "Authorization".equalsIgnoreCase((String)entry.getKey()) ? "<redacted" : (String)entry.getValue())));
        return JsonUtils.fromJson(responseWrapper.response(), TokenResponse.class);
    }

    static boolean isSameOrigin(URI uri1, URI uri2) {
        return Objects.equals(uri1.getScheme(), uri2.getScheme()) && Objects.equals(uri1.getHost(), uri2.getHost()) && HttpClient.getPort(uri1) == HttpClient.getPort(uri2);
    }

    static int getPort(URI uri) {
        return uri.getPort() != -1 ? uri.getPort() : ("https".equals(uri.getScheme()) ? 443 : 80);
    }

    static <T> boolean shouldRedirect(HttpResponse<T> response) {
        return response.statusCode() == 301 || response.statusCode() == 302 || response.statusCode() == 307;
    }

    private <T> ResponseWrapper<T> executeRequest(String method, URI uri, boolean includeAuthHeader, Map<String, String> headers, byte[] body, HttpResponse.BodyHandler<T> handler, HttpRequest.BodyPublisher bodyPublisher, Scopes scopes, AuthProvider authProvider) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).method(method, bodyPublisher);
            ContainerRef containerRef = scopes.getContainerRef();
            Scopes newScopes = switch (method) {
                case "GET", "HEAD" -> scopes.withNewRegistryScopes(Scope.PULL);
                case "POST", "PUT", "PATCH" -> scopes.withNewRegistryScopes(Scope.PUSH);
                case "DELETE" -> scopes.withNewRegistryScopes(Scope.DELETE);
                default -> throw new OrasException("Unsupported HTTP method: " + method);
            };
            LOG.debug("Existing scopes: {}", scopes.getScopes());
            LOG.debug("New scopes: {}", newScopes.getScopes());
            if (authProvider.getAuthHeader(containerRef) != null && !authProvider.getAuthScheme().equals((Object)AuthScheme.NONE) && includeAuthHeader) {
                builder = builder.header("Authorization", authProvider.getAuthHeader(containerRef));
            }
            headers.forEach(builder::header);
            builder = builder.header("User-Agent", "ORAS-Java-SDK/0.3.1");
            HttpRequest request = builder.build();
            this.logRequest(request, body);
            HttpResponse<T> response = this.client.send(request, handler);
            if (HttpClient.shouldRedirect(response)) {
                String location = this.getLocationHeader(response);
                URI redirectUri = URI.create(location);
                LOG.debug("Redirecting to {} from domain {} to domain {}", new Object[]{location, uri, redirectUri});
                boolean includeAuthHeaderForRedirect = HttpClient.isSameOrigin(uri, redirectUri);
                if (!includeAuthHeaderForRedirect) {
                    LOG.debug("Skipping auth header for redirect from {} to {}", (Object)uri, (Object)redirectUri);
                }
                return this.executeRequest(method, redirectUri, includeAuthHeaderForRedirect, headers, body, handler, bodyPublisher, newScopes, authProvider);
            }
            return this.redoRequest(response, builder, handler, newScopes, authProvider);
        }
        catch (Exception e) {
            LOG.error("Failed to execute request", (Throwable)e);
            throw new OrasException("Unable to create HTTP request", e);
        }
    }

    private <T> String getLocationHeader(HttpResponse<T> response) {
        return response.headers().firstValue("Location").orElseThrow(() -> new OrasException("No Location header found"));
    }

    private <T> ResponseWrapper<T> redoRequest(HttpResponse<T> response, HttpRequest.Builder builder, HttpResponse.BodyHandler<T> handler, Scopes scopes, AuthProvider authProvider) {
        if (response.statusCode() == 401 || response.statusCode() == 403) {
            LOG.debug("Requesting new token...");
            TokenResponse token = this.refreshToken(this.toResponseWrapper(response), scopes, authProvider);
            if (token.issued_at() != null && token.expires_in() != null) {
                LOG.debug("Found token issued_at {}, expire_id {} and expiring at {} ", new Object[]{token.issued_at(), token.expires_in(), token.issued_at().plusSeconds(token.expires_in().intValue())});
            }
            try {
                builder = builder.setHeader("Authorization", "Bearer " + token.token());
                HttpResponse<T> newResponse = this.client.send(builder.build(), handler);
                if (HttpClient.shouldRedirect(newResponse)) {
                    String location = this.getLocationHeader(newResponse);
                    LOG.debug("Redirecting after auth to {}", (Object)location);
                    return this.toResponseWrapper(this.client.send(builder.uri(URI.create(location)).build(), handler));
                }
                return this.toResponseWrapper(newResponse);
            }
            catch (Exception e) {
                LOG.error("Failed to redo request", (Throwable)e);
                throw new OrasException("Unable to redo HTTP request", e);
            }
        }
        return this.toResponseWrapper(response);
    }

    private <T> ResponseWrapper<T> toResponseWrapper(HttpResponse<T> response) {
        return new ResponseWrapper<T>(response.body(), response.statusCode(), response.headers().map().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0))));
    }

    private void logRequest(HttpRequest request, byte[] body) {
        LOG.debug("Executing {} request to {}", (Object)request.method(), (Object)request.uri());
        LOG.debug("Headers: {}", request.headers().map().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "Authorization".equalsIgnoreCase((String)entry.getKey()) ? List.of("<redacted>") : (List)entry.getValue())));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Body: {}", (Object)new String(body, StandardCharsets.UTF_8));
        }
    }

    private static class InsecureTrustManager
    extends X509ExtendedTrustManager {
        private InsecureTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }
    }

    public record ResponseWrapper<T>(T response, int statusCode, Map<String, String> headers) {
    }

    @OrasModel
    public record TokenResponse(String token, @Nullable String access_token, @Nullable Integer expires_in, @Nullable ZonedDateTime issued_at) {
    }

    public static class Builder {
        private final HttpClient client = new HttpClient();

        private Builder() {
        }

        public Builder withTimeout(@Nullable Integer timeout) {
            this.client.setTimeout(timeout);
            return this;
        }

        public Builder withSkipTlsVerify(boolean skipTlsVerify) {
            this.client.setTlsVerify(skipTlsVerify);
            return this;
        }

        public static Builder builder() {
            return new Builder();
        }

        public HttpClient build() {
            return this.client.build();
        }
    }
}

