/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import land.oras.ContainerRef;
import land.oras.exception.OrasException;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class AuthStore {
    private static final Logger LOG = LoggerFactory.getLogger(AuthStore.class);
    private static final String ALL_REGISTRIES_HELPER = "*";
    private final Config config;

    AuthStore(Config config) {
        this.config = Objects.requireNonNull(config, "Config cannot be null");
    }

    public static AuthStore newStore(List<Path> configPaths) {
        ArrayList<ConfigFile> files = new ArrayList<ConfigFile>();
        for (Path configPath : configPaths) {
            if (!Files.exists(configPath, new LinkOption[0])) continue;
            ConfigFile configFile = JsonUtils.fromJson(configPath, ConfigFile.class);
            LOG.debug("Loaded auth config file: {}", (Object)configPath);
            files.add(configFile);
        }
        return new AuthStore(Config.load(files));
    }

    public static AuthStore newStore() {
        Path dockerPath = Path.of(System.getProperty("user.home"), ".docker", "config.json");
        List<Path> paths = List.of(dockerPath, System.getenv("XDG_RUNTIME_DIR") != null ? Path.of(System.getenv("XDG_RUNTIME_DIR"), "containers", "auth.json") : dockerPath);
        return AuthStore.newStore(paths);
    }

    public @Nullable Credential get(ContainerRef containerRef) throws OrasException {
        return this.config.getCredential(containerRef);
    }

    public @Nullable String getCredentialHelperBinary(ContainerRef containerRef) {
        String helper = this.config.credentialHelperStore.get(containerRef.getRegistry());
        if (helper == null) {
            return null;
        }
        return "docker-credential-" + helper;
    }

    static class Config {
        private final ConcurrentHashMap<String, Credential> credentialStore = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, String> credentialHelperStore = new ConcurrentHashMap();

        private Config() {
        }

        public static Config load(List<ConfigFile> configFiles) throws OrasException {
            Config config = new Config();
            for (ConfigFile configFile : configFiles) {
                config.credentialHelperStore.putAll(configFile.credHelpers != null ? configFile.credHelpers : Map.of());
                config.credentialHelperStore.putAll(configFile.credsStore != null ? Map.of(AuthStore.ALL_REGISTRIES_HELPER, configFile.credsStore) : Map.of());
                configFile.auths.forEach((host, value) -> {
                    String auth = (String)value.get("auth");
                    if (auth != null) {
                        String base64Decoded = new String(Base64.getDecoder().decode(auth));
                        String[] parts = base64Decoded.split(":");
                        if (parts.length != 2) {
                            throw new OrasException("Invalid credential format");
                        }
                        config.credentialStore.put((String)host, new Credential(parts[0], parts[1]));
                    }
                });
            }
            return config;
        }

        public @Nullable Credential getCredential(ContainerRef containerRef) throws OrasException {
            String registry = containerRef.getRegistry();
            LOG.debug("Looking for credentials for registry '{}'", (Object)registry);
            Credential cred = this.credentialStore.get(registry);
            if (cred != null) {
                return cred;
            }
            String helperSuffix = this.credentialHelperStore.get(registry);
            if (helperSuffix != null) {
                try {
                    LOG.debug("Using credential helper '{}' for registry '{}'", (Object)helperSuffix, (Object)registry);
                    return Config.getFromCredentialHelper(helperSuffix, registry);
                }
                catch (OrasException e) {
                    LOG.warn("Failed to get credential from helper for registry {}: {}", (Object)registry, (Object)e.getMessage());
                }
            }
            if ((helperSuffix = this.credentialHelperStore.get(AuthStore.ALL_REGISTRIES_HELPER)) != null) {
                try {
                    LOG.debug("Using all-registries credential helper for registry '{}'", (Object)registry);
                    return Config.getFromCredentialHelper(helperSuffix, registry);
                }
                catch (OrasException e) {
                    LOG.warn("Failed to get credential from all-registries helper for registry {}: {}", (Object)registry, (Object)e.getMessage());
                }
            }
            return null;
        }

        private static Credential getFromCredentialHelper(String suffix, String hostname) throws OrasException {
            LOG.debug("Looking for credential helper 'docker-credential-{}' for hostname '{}'", (Object)suffix, (Object)hostname);
            String binary = "docker-credential-" + suffix;
            ProcessBuilder pb = new ProcessBuilder(binary, "get");
            try {
                Process proc = pb.start();
                try (OutputStream os = proc.getOutputStream();){
                    os.write(hostname.getBytes(StandardCharsets.UTF_8));
                    os.flush();
                }
                int exit = proc.waitFor();
                if (exit != 0) {
                    String stderr = new String(proc.getErrorStream().readAllBytes(), StandardCharsets.UTF_8);
                    String stdout = new String(proc.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                    String message = "Credential helper '%s' exited with code %d and error: '%s' and stdout '%s'.".formatted(binary, exit, stderr.trim(), stdout.trim());
                    LOG.warn(message);
                    throw new OrasException(message);
                }
                return JsonUtils.fromJson(proc.getInputStream(), CredentialHelperResponse.class).asCredential();
            }
            catch (IOException e) {
                LOG.warn("Failed to execute credential helper '{}': {}", (Object)binary, (Object)e.getMessage());
                throw new OrasException("Credential helper '" + binary + "' not found or IO error", e);
            }
            catch (InterruptedException e) {
                LOG.warn("Credential helper execution interrupted: {}", (Object)e.getMessage());
                throw new OrasException("Credential helper execution interrupted", e);
            }
        }
    }

    record ConfigFile(Map<String, Map<String, String>> auths, @Nullable Map<String, String> credHelpers, @Nullable String credsStore) {
        static ConfigFile fromCredential(Credential credential) {
            return new ConfigFile(Map.of("auths", Map.of("auth", Base64.getEncoder().encodeToString((credential.username + ":" + credential.password).getBytes()))), Map.of(), null);
        }
    }

    public record Credential(String username, String password) {
        public Credential(String username, String password) {
            this.username = Objects.requireNonNull(username, "Username cannot be null");
            this.password = Objects.requireNonNull(password, "Password cannot be null");
        }
    }

    public record CredentialHelperResponse(@JsonProperty(value="ServerURL") String serverUrl, @JsonProperty(value="Username") String username, @JsonProperty(value="Secret") String secret) {
        public Credential asCredential() {
            return new Credential(this.username, this.secret);
        }
    }
}

