/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import land.oras.Annotations;
import land.oras.ArtifactType;
import land.oras.Config;
import land.oras.Descriptor;
import land.oras.Index;
import land.oras.Layer;
import land.oras.LayoutRef;
import land.oras.LocalPath;
import land.oras.Manifest;
import land.oras.ManifestDescriptor;
import land.oras.OCI;
import land.oras.OrasModel;
import land.oras.Referrers;
import land.oras.Repositories;
import land.oras.Subject;
import land.oras.Tags;
import land.oras.exception.OrasException;
import land.oras.utils.Const;
import land.oras.utils.JsonUtils;
import land.oras.utils.SupportedAlgorithm;
import org.jspecify.annotations.Nullable;

@OrasModel
public final class OCILayout
extends OCI<LayoutRef> {
    private final String imageLayoutVersion = "1.0.0";
    private Path path;

    private OCILayout() {
    }

    public static Builder builder() {
        return Builder.builder();
    }

    @Override
    public Manifest pushArtifact(LayoutRef ref, ArtifactType artifactType, Annotations annotations, @Nullable Config config, LocalPath ... paths) {
        Manifest manifest = Manifest.empty().withArtifactType(artifactType);
        HashMap<String, String> manifestAnnotations = new HashMap<String, String>(annotations.manifestAnnotations());
        if (!manifestAnnotations.containsKey("org.opencontainers.image.created")) {
            manifestAnnotations.put("org.opencontainers.image.created", Const.currentTimestamp());
        }
        manifest = manifest.withAnnotations(manifestAnnotations);
        if (config != null) {
            config = config.withAnnotations(annotations);
            manifest = manifest.withConfig(config);
        }
        List<Layer> layers = this.pushLayers(ref, true, paths);
        Config configToPush = config != null ? config : Config.empty();
        Config pushedConfig = this.pushConfig(ref.withTag(configToPush.getDigest()), configToPush);
        manifest = manifest.withLayers(layers).withConfig(pushedConfig);
        manifest = this.pushManifest(ref, manifest);
        LOG.debug("Manifest pushed to: {}", (Object)ref.withTag(manifest.getDescriptor().getDigest()));
        return manifest;
    }

    @Override
    public void pullArtifact(LayoutRef ref, Path path, boolean overwrite) {
        if (ref.getTag() == null) {
            throw new OrasException("Tag is required to pull artifact from layout");
        }
        Manifest manifest = this.getManifest(ref);
        Layer layer = manifest.getLayers().stream().filter(l -> l.getAnnotations().containsKey("org.opencontainers.image.title")).findFirst().orElseThrow(() -> new OrasException("Layer not found with title annotation"));
        Path blobPath = this.getBlobPath(layer);
        try {
            Files.copy(blobPath, path.resolve(layer.getAnnotations().get("org.opencontainers.image.title")), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new OrasException("Failed to copy blob", e);
        }
    }

    @Override
    public Manifest pushManifest(LayoutRef layoutRef, Manifest manifest) {
        if (manifest.getLayers().isEmpty()) {
            Config config = manifest.getConfig();
            Layer configLayer = Layer.fromJson(config.toJson());
            manifest = manifest.withLayers(List.of(configLayer));
        }
        byte[] manifestData = this.getDescriptorData(manifest);
        String manifestDigest = this.digest(layoutRef, manifest);
        ManifestDescriptor manifestDescriptor = ManifestDescriptor.of("application/vnd.oci.image.manifest.v1+json", manifestDigest, manifestData.length).withAnnotations(manifest.getAnnotations().isEmpty() ? null : manifest.getAnnotations()).withArtifactType(manifest.getArtifactType().getMediaType());
        if (layoutRef.getTag() != null && !layoutRef.isValidDigest()) {
            HashMap<String, String> newAnnotations = new HashMap<String, String>();
            if (manifestDescriptor.getAnnotations() != null) {
                newAnnotations.putAll(manifestDescriptor.getAnnotations());
            }
            newAnnotations.put("org.opencontainers.image.ref.name", layoutRef.getTag());
            manifestDescriptor = manifestDescriptor.withAnnotations(newAnnotations);
        }
        manifest = manifest.withDescriptor(manifestDescriptor);
        Index index = Index.fromPath(this.getIndexPath()).withNewManifests(manifestDescriptor);
        try {
            this.writeManifest(manifest);
            this.writeOCIIndex(index);
        }
        catch (IOException e) {
            throw new OrasException("Failed to write manifest", e);
        }
        return manifest;
    }

    @Override
    public Index pushIndex(LayoutRef layoutRef, Index index) {
        byte[] indexData = this.getDescriptorData(index);
        String indexDigest = this.digest(layoutRef, index);
        ManifestDescriptor indexDescriptor = ManifestDescriptor.of("application/vnd.oci.image.index.v1+json", indexDigest, indexData.length).withAnnotations(index.getAnnotations() == null || index.getAnnotations().isEmpty() ? null : index.getAnnotations()).withArtifactType(index.getMediaType());
        if (layoutRef.getTag() != null && !layoutRef.isValidDigest()) {
            HashMap<String, String> newAnnotations = new HashMap<String, String>();
            if (index.getAnnotations() != null) {
                newAnnotations.putAll(index.getAnnotations());
            }
            newAnnotations.put("org.opencontainers.image.ref.name", layoutRef.getTag());
            indexDescriptor = indexDescriptor.withAnnotations(newAnnotations);
        }
        index = index.withDescriptor(indexDescriptor);
        Index ociIndex = Index.fromPath(this.getIndexPath()).withNewManifests(indexDescriptor);
        try {
            this.writeIndex(index);
            this.writeOCIIndex(ociIndex);
        }
        catch (IOException e) {
            throw new OrasException("Failed to write manifest", e);
        }
        return index;
    }

    @Override
    public Index getIndex(LayoutRef ref) {
        Path path = this.getIndexPath();
        return Index.fromPath(path);
    }

    @Override
    public Manifest getManifest(LayoutRef ref) {
        String tag = ref.getTag();
        if (tag == null) {
            throw new OrasException("Tag or digest is required to find manifest");
        }
        ManifestDescriptor descriptor = this.findManifestDescriptor(ref);
        Path manifestPath = this.getBlobPath(descriptor);
        if (!Files.exists(manifestPath, new LinkOption[0])) {
            throw new OrasException("Blob not found: %s".formatted(manifestPath));
        }
        return Manifest.fromPath(manifestPath).withDescriptor(descriptor);
    }

    @Override
    public byte[] getBlob(LayoutRef layoutRef) {
        byte[] byArray;
        block8: {
            InputStream is = this.fetchBlob(layoutRef);
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OrasException("Failed to get blob", e);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public void fetchBlob(LayoutRef ref, Path path) {
        InputStream is = this.fetchBlob(ref);
        try {
            Files.copy(is, path, new CopyOption[0]);
            LOG.info("Downloaded: {}", (Object)ref.getTag());
        }
        catch (IOException e) {
            throw new OrasException("Failed to fetch blob", e);
        }
    }

    @Override
    public InputStream fetchBlob(LayoutRef ref) {
        Path blobPath = this.getBlobPath(ref);
        try {
            return Files.newInputStream(blobPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OrasException("Failed to fetch blob", e);
        }
    }

    @Override
    public Descriptor fetchBlobDescriptor(LayoutRef ref) {
        if (ref.getTag() == null) {
            throw new OrasException("Tag or digest is required to get blob from layout");
        }
        if (SupportedAlgorithm.isSupported(ref.getTag())) {
            return Descriptor.of(ref.getTag(), this.size(this.getBlobPath(ref)));
        }
        return this.findManifestDescriptor(ref).toDescriptor();
    }

    @Override
    public Layer pushBlob(LayoutRef ref, Path blob, Map<String, String> annotations) {
        this.ensureDigest(ref, blob);
        Path blobPath = this.getBlobPath(ref);
        String digest = ref.getAlgorithm().digest(blob);
        this.ensureAlgorithmPath(digest);
        LOG.debug("Digest: {}", (Object)digest);
        try {
            if (Files.exists(blobPath, new LinkOption[0])) {
                LOG.info("Blob already exists: {}", (Object)digest);
                return Layer.fromFile(blobPath, ref.getAlgorithm()).withAnnotations(annotations);
            }
            Files.copy(blob, blobPath, new CopyOption[0]);
            return Layer.fromFile(blobPath, ref.getAlgorithm()).withAnnotations(annotations);
        }
        catch (IOException e) {
            throw new OrasException("Failed to push blob", e);
        }
    }

    @Override
    public Layer pushBlob(LayoutRef ref, byte[] data) {
        try {
            Path path = Files.createTempFile("oras", "blob", new FileAttribute[0]);
            Files.write(path, data, new OpenOption[0]);
            this.ensureDigest(ref, path);
            String digest = ref.getAlgorithm().digest(data);
            this.ensureAlgorithmPath(digest);
            return this.pushBlob(ref, path, Map.of());
        }
        catch (IOException e) {
            throw new OrasException("Failed to push blob to OCI layout", e);
        }
    }

    @Override
    public Tags getTags(LayoutRef ref) {
        Index index = Index.fromPath(this.getIndexPath());
        String name = ref.getFolder().getFileName().toString();
        List<String> tags = index.getManifests().stream().filter(m -> m.getAnnotations() != null && m.getAnnotations().containsKey("org.opencontainers.image.ref.name")).map(m -> m.getAnnotations().get("org.opencontainers.image.ref.name")).toList();
        return new Tags(name, tags);
    }

    @Override
    public Repositories getRepositories() {
        return new Repositories(List.of(this.path.getFileName().toString()));
    }

    @Override
    public Referrers getReferrers(LayoutRef ref, @Nullable ArtifactType artifactType) {
        Index index = Index.fromPath(this.getIndexPath());
        ManifestDescriptor currentDescriptor = this.findManifestDescriptor(ref);
        String currentDescriptorDigest = currentDescriptor.getDigest();
        LOG.info("Looking for referrers of manifest: {}", (Object)currentDescriptorDigest);
        LinkedList<ManifestDescriptor> manifestDescriptors = new LinkedList<ManifestDescriptor>();
        for (ManifestDescriptor manifestDescriptor : index.getManifests()) {
            Subject subject;
            String subjectDigest;
            String digest = manifestDescriptor.getDigest();
            Descriptor descriptor = this.probeDescriptor(ref.withDigest(digest));
            Descriptor describable = this.isIndexMediaType(descriptor.getMediaType()) ? this.getIndex(ref.withDigest(digest)) : this.getManifest(ref.withDigest(digest));
            if (describable.getSubject() == null || !(subjectDigest = (subject = describable.getSubject()).getDigest()).equals(currentDescriptorDigest)) continue;
            LOG.info("Subject with digest {} found for manifest: {}", (Object)subjectDigest, (Object)digest);
            manifestDescriptors.add(manifestDescriptor);
        }
        return Referrers.from(manifestDescriptors);
    }

    private void setPath(Path path) {
        this.path = path;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }

    public static OCILayout fromJson(String json) {
        return JsonUtils.fromJson(json, OCILayout.class);
    }

    public String getImageLayoutVersion() {
        return "1.0.0";
    }

    private void ensureMinimalLayout() {
        try {
            Files.createDirectories(this.getBlobPath(), new FileAttribute[0]);
            if (!Files.exists(this.getOciLayoutPath(), new LinkOption[0])) {
                Files.writeString(this.getOciLayoutPath(), (CharSequence)this.toJson(), new OpenOption[0]);
            }
            if (!Files.exists(this.getIndexPath(), new LinkOption[0])) {
                Files.writeString(this.getIndexPath(), (CharSequence)Index.fromManifests(List.of()).toJson(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new OrasException("Failed to create layout", e);
        }
    }

    private void ensureAlgorithmPath(String digest) {
        Path prefixDirectory = this.getBlobAlgorithmPath(digest);
        try {
            if (!Files.exists(prefixDirectory, new LinkOption[0])) {
                Files.createDirectory(prefixDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new OrasException("Failed to create algorithm path", e);
        }
    }

    @Override
    public Descriptor getDescriptor(LayoutRef ref) {
        String tag = ref.getTag();
        if (tag == null) {
            throw new OrasException("Tag or digest is required to find manifest");
        }
        ManifestDescriptor manifestDescriptor = this.findManifestDescriptor(ref);
        return manifestDescriptor.toDescriptor();
    }

    @Override
    public Descriptor probeDescriptor(LayoutRef ref) {
        return this.getDescriptor(ref).withJson(null);
    }

    private byte[] getDescriptorData(Descriptor descriptor) {
        if (descriptor.getJson() != null) {
            return descriptor.getJson().getBytes();
        }
        return descriptor.toJson().getBytes();
    }

    private String digest(LayoutRef layoutRef, Descriptor descriptor) {
        return layoutRef.getAlgorithm().digest(descriptor.getJson() != null ? descriptor.getJson().getBytes() : descriptor.toJson().getBytes());
    }

    private Path getOciLayoutPath() {
        return this.path.resolve("oci-layout");
    }

    private Path getBlobPath() {
        return this.path.resolve("blobs");
    }

    private Path getBlobPath(LayoutRef ref) {
        if (ref.getTag() == null) {
            throw new OrasException("Tag is required to get blob from layout");
        }
        boolean isDigest = SupportedAlgorithm.isSupported(ref.getTag());
        if (isDigest) {
            SupportedAlgorithm algorithm = SupportedAlgorithm.fromDigest(ref.getTag());
            return this.getBlobPath().resolve(algorithm.getPrefix()).resolve(SupportedAlgorithm.getDigest(ref.getTag()));
        }
        Manifest manifest = this.getManifest(ref);
        return this.getBlobPath(manifest.getDescriptor());
    }

    private long size(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new OrasException("Failed to get size", e);
        }
    }

    private ManifestDescriptor findManifestDescriptor(LayoutRef ref) {
        String tag = ref.getTag();
        if (tag == null) {
            throw new OrasException("Tag or digest is required to find manifest");
        }
        Index index = Index.fromPath(this.getIndexPath());
        return index.getManifests().stream().filter(m -> m.getAnnotations() != null && tag.equals(m.getAnnotations().get("org.opencontainers.image.ref.name")) || tag.equals(m.getDigest())).findFirst().orElseThrow(() -> new OrasException("Tag or digest not found: %s".formatted(tag)));
    }

    private Path getBlobPath(ManifestDescriptor manifestDescriptor) {
        String digest = manifestDescriptor.getDigest();
        SupportedAlgorithm algorithm = SupportedAlgorithm.fromDigest(digest);
        return this.getBlobPath().resolve(algorithm.getPrefix()).resolve(SupportedAlgorithm.getDigest(digest));
    }

    private Path getBlobPath(Layer layer) {
        String digest = layer.getDigest();
        SupportedAlgorithm algorithm = SupportedAlgorithm.fromDigest(digest);
        return this.getBlobPath().resolve(algorithm.getPrefix()).resolve(SupportedAlgorithm.getDigest(digest));
    }

    private Path getIndexPath() {
        return this.path.resolve("index.json");
    }

    private Path getIndexBlobPath(Index index) {
        ManifestDescriptor descriptor = index.getDescriptor();
        if (descriptor == null) {
            throw new OrasException("Index descriptor is required when writing index blob with existing JSON");
        }
        String digest = descriptor.getDigest();
        return this.getBlobAlgorithmPath(digest).resolve(SupportedAlgorithm.getDigest(digest));
    }

    private Path getBlobAlgorithmPath(String digest) {
        SupportedAlgorithm algorithm = SupportedAlgorithm.fromDigest(digest);
        return this.getBlobPath().resolve(algorithm.getPrefix());
    }

    private void writeOCIIndex(Index index) throws IOException {
        Path indexFile = this.getIndexPath();
        Files.writeString(indexFile, (CharSequence)(index.getJson() != null ? index.getJson() : index.toJson()), new OpenOption[0]);
        if (index.getJson() != null) {
            Files.writeString(this.getIndexBlobPath(index), (CharSequence)index.getJson(), new OpenOption[0]);
        }
    }

    private void writeManifest(Manifest manifest) throws IOException {
        ManifestDescriptor descriptor = manifest.getDescriptor();
        Path manifestFile = this.getBlobPath(descriptor);
        Path manifestPrefixDirectory = this.getBlobAlgorithmPath(manifest.getDescriptor().getDigest());
        if (!Files.exists(manifestPrefixDirectory, new LinkOption[0])) {
            Files.createDirectory(manifestPrefixDirectory, new FileAttribute[0]);
        }
        if (Files.exists(manifestFile, new LinkOption[0])) {
            LOG.debug("Manifest already exists: {}", (Object)manifestFile);
            return;
        }
        if (manifest.getJson() == null) {
            LOG.debug("Writing new manifest: {}", (Object)manifestFile);
            Files.writeString(manifestFile, (CharSequence)manifest.toJson(), new OpenOption[0]);
        } else {
            LOG.debug("Writing existing manifest: {}", (Object)manifestFile);
            Files.writeString(manifestFile, (CharSequence)manifest.getJson(), new OpenOption[0]);
        }
    }

    private void writeIndex(Index index) throws IOException {
        ManifestDescriptor descriptor = index.getDescriptor();
        Path manifestFile = this.getBlobPath(descriptor);
        Path manifestPrefixDirectory = this.getBlobAlgorithmPath(index.getDescriptor().getDigest());
        if (!Files.exists(manifestPrefixDirectory, new LinkOption[0])) {
            Files.createDirectory(manifestPrefixDirectory, new FileAttribute[0]);
        }
        if (Files.exists(manifestFile, new LinkOption[0])) {
            LOG.debug("Manifest already exists: {}", (Object)manifestFile);
            return;
        }
        if (index.getJson() == null) {
            LOG.debug("Writing new manifest: {}", (Object)manifestFile);
            Files.writeString(manifestFile, (CharSequence)index.toJson(), new OpenOption[0]);
        } else {
            LOG.debug("Writing existing manifest: {}", (Object)manifestFile);
            Files.writeString(manifestFile, (CharSequence)index.getJson(), new OpenOption[0]);
        }
    }

    private void ensureDigest(LayoutRef ref, Path path) {
        if (ref.getTag() == null) {
            throw new OrasException("Missing ref");
        }
        if (!SupportedAlgorithm.isSupported(ref.getTag())) {
            throw new OrasException("Unsupported digest: %s".formatted(ref.getTag()));
        }
        SupportedAlgorithm algorithm = SupportedAlgorithm.fromDigest(ref.getTag());
        String pathDigest = algorithm.digest(path);
        if (!ref.getTag().equals(pathDigest)) {
            throw new OrasException("Digest mismatch: %s != %s".formatted(ref.getTag(), pathDigest));
        }
    }

    public static OCILayout fromLayoutIndex(Path layoutPath) {
        OCILayout layout = JsonUtils.fromJson(layoutPath.resolve("index.json"), OCILayout.class);
        layout.path = layoutPath;
        return layout;
    }

    @JsonIgnore
    public Path getPath() {
        return this.path;
    }

    public static class Builder {
        private final OCILayout layout = new OCILayout();

        private Builder() {
        }

        public Builder defaults(Path path) {
            this.layout.setPath(path);
            return this;
        }

        public static Builder builder() {
            return new Builder();
        }

        public OCILayout build() {
            if (!Files.isDirectory(this.layout.path, new LinkOption[0])) {
                try {
                    Files.createDirectory(this.layout.path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new OrasException("Failed to create OCI layout directory", e);
                }
            }
            this.layout.ensureMinimalLayout();
            return this.layout;
        }
    }
}

