/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import land.oras.Annotations;
import land.oras.ArtifactType;
import land.oras.Config;
import land.oras.Descriptor;
import land.oras.Index;
import land.oras.Layer;
import land.oras.LocalPath;
import land.oras.Manifest;
import land.oras.ManifestDescriptor;
import land.oras.Ref;
import land.oras.Referrers;
import land.oras.Repositories;
import land.oras.Subject;
import land.oras.Tags;
import land.oras.exception.OrasException;
import land.oras.utils.ArchiveUtils;
import land.oras.utils.Const;
import land.oras.utils.SupportedAlgorithm;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class OCI<T extends Ref<@NonNull T>> {
    protected static final Logger LOG = LoggerFactory.getLogger(OCI.class);

    protected OCI() {
    }

    public Manifest pushArtifact(T ref, LocalPath ... paths) {
        return this.pushArtifact(ref, ArtifactType.unknown(), Annotations.empty(), Config.empty(), paths);
    }

    public Manifest pushArtifact(T ref, ArtifactType artifactType, LocalPath ... paths) {
        return this.pushArtifact(ref, artifactType, Annotations.empty(), Config.empty(), paths);
    }

    public Manifest pushArtifact(T ref, ArtifactType artifactType, Annotations annotations, LocalPath ... paths) {
        return this.pushArtifact(ref, artifactType, annotations, Config.empty(), paths);
    }

    public Layer pushBlob(T ref, Path blob) {
        return this.pushBlob(ref, blob, Map.of());
    }

    public Layer pushBlob(T ref, InputStream input) {
        try {
            Path tempFile = Files.createTempFile("oras", "layer", new FileAttribute[0]);
            Files.copy(input, tempFile, StandardCopyOption.REPLACE_EXISTING);
            return this.pushBlob(ref, tempFile);
        }
        catch (IOException e) {
            throw new OrasException("Failed to push blob", e);
        }
    }

    protected List<Layer> collectLayers(T ref, String contentType, boolean includeAll) {
        LinkedList<Layer> layers = new LinkedList<Layer>();
        if (this.isManifestMediaType(contentType)) {
            return this.getManifest(ref).getLayers();
        }
        Index index = this.getIndex(ref);
        for (ManifestDescriptor manifestDescriptor : index.getManifests()) {
            List<Layer> manifestLayers = this.getManifest(((Ref)ref).withDigest(manifestDescriptor.getDigest())).getLayers();
            for (Layer manifestLayer : manifestLayers) {
                if (manifestLayer.getAnnotations().isEmpty() || !manifestLayer.getAnnotations().containsKey("org.opencontainers.image.title")) {
                    if (includeAll) {
                        LOG.debug("Including layer without title annotation: {}", (Object)manifestLayer.getDigest());
                        layers.add(manifestLayer);
                    }
                    LOG.debug("Skipping layer without title annotation: {}", (Object)manifestLayer.getDigest());
                    continue;
                }
                layers.add(manifestLayer);
            }
        }
        return layers;
    }

    protected final List<Layer> pushLayers(T ref, boolean withDigest, LocalPath ... paths) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (LocalPath path : paths) {
            try {
                if (Files.isDirectory(path.getPath(), new LinkOption[0])) {
                    LocalPath tempTar = ArchiveUtils.tar(path);
                    LocalPath tempArchive = ArchiveUtils.compress(tempTar, path.getMediaType());
                    if (withDigest) {
                        ref = ((Ref)ref).withDigest(((Ref)ref).getAlgorithm().digest(tempArchive.getPath()));
                    }
                    try (InputStream is = Files.newInputStream(tempArchive.getPath(), new OpenOption[0]);){
                        String title = path.getPath().isAbsolute() ? path.getPath().getFileName().toString() : path.getPath().toString();
                        LOG.debug("Uploading directory as archive with title: {}", (Object)title);
                        Layer layer = this.pushBlob(ref, is).withMediaType(path.getMediaType()).withAnnotations(Map.of("org.opencontainers.image.title", title, "io.deis.oras.content.digest", ((Ref)ref).getAlgorithm().digest(tempTar.getPath()), "io.deis.oras.content.unpack", "true"));
                        layers.add(layer);
                        LOG.info("Uploaded directory: {}", (Object)layer.getDigest());
                    }
                    Files.delete(tempArchive.getPath());
                    continue;
                }
                try (InputStream is = Files.newInputStream(path.getPath(), new OpenOption[0]);){
                    if (withDigest) {
                        ref = ((Ref)ref).withDigest(((Ref)ref).getAlgorithm().digest(path.getPath()));
                    }
                    Layer layer = this.pushBlob(ref, is).withMediaType(path.getMediaType()).withAnnotations(Map.of("org.opencontainers.image.title", path.getPath().getFileName().toString()));
                    layers.add(layer);
                    LOG.info("Uploaded: {}", (Object)layer.getDigest());
                }
            }
            catch (IOException e) {
                throw new OrasException("Failed to push artifact", e);
            }
        }
        return layers;
    }

    protected boolean isIndexMediaType(String mediaType) {
        return mediaType.equals("application/vnd.oci.image.index.v1+json") || mediaType.equals("application/vnd.docker.distribution.manifest.list.v2+json");
    }

    protected boolean isManifestMediaType(String mediaType) {
        return mediaType.equals("application/vnd.oci.image.manifest.v1+json") || mediaType.equals("application/vnd.docker.distribution.manifest.v2+json");
    }

    public final Config pushConfig(T ref, Config config) {
        Layer layer = this.pushBlob(ref, config.getDataBytes());
        LOG.debug("Config pushed: {}", (Object)layer.getDigest());
        return config;
    }

    public final InputStream pullConfig(T ref, Config config) {
        if (config.getData() != null) {
            return new ByteArrayInputStream(config.getDataBytes());
        }
        String digest = config.getDigest();
        return this.fetchBlob(((Ref)ref).withDigest(digest));
    }

    public final Manifest attachArtifact(T ref, ArtifactType artifactType, LocalPath ... paths) {
        return this.attachArtifact(ref, artifactType, Annotations.empty(), paths);
    }

    public abstract Tags getTags(T var1);

    public abstract Repositories getRepositories();

    public abstract Manifest pushArtifact(T var1, ArtifactType var2, Annotations var3, @Nullable Config var4, LocalPath ... var5);

    public abstract void pullArtifact(T var1, Path var2, boolean var3);

    public abstract Manifest pushManifest(T var1, Manifest var2);

    public abstract Index pushIndex(T var1, Index var2);

    public abstract Index getIndex(T var1);

    public abstract Manifest getManifest(T var1);

    public abstract Descriptor getDescriptor(T var1);

    public abstract Descriptor probeDescriptor(T var1);

    public abstract byte[] getBlob(T var1);

    public abstract void fetchBlob(T var1, Path var2);

    public abstract InputStream fetchBlob(T var1);

    public abstract Descriptor fetchBlobDescriptor(T var1);

    public abstract Layer pushBlob(T var1, Path var2, Map<String, String> var3);

    public abstract Layer pushBlob(T var1, byte[] var2);

    public abstract Referrers getReferrers(T var1, @Nullable ArtifactType var2);

    public Manifest attachArtifact(T ref, ArtifactType artifactType, Annotations annotations, LocalPath ... paths) {
        List<Layer> layers = this.pushLayers(ref, true, paths);
        Descriptor descriptor = this.getDescriptor(ref);
        Subject subject = descriptor.toSubject();
        Map<String, String> manifestAnnotations = annotations.manifestAnnotations();
        if (!manifestAnnotations.containsKey("org.opencontainers.image.created")) {
            manifestAnnotations.put("org.opencontainers.image.created", Const.currentTimestamp());
        }
        Manifest manifest = Manifest.empty().withArtifactType(artifactType).withAnnotations(manifestAnnotations).withLayers(layers).withSubject(subject);
        return this.pushManifest(((Ref)ref).withDigest(SupportedAlgorithm.getDefault().digest(manifest.toJson().getBytes(StandardCharsets.UTF_8))), manifest);
    }
}

