/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.nio.file.Path;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import land.oras.OCILayout;
import land.oras.OrasModel;
import land.oras.Ref;
import land.oras.exception.OrasException;
import land.oras.utils.SupportedAlgorithm;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@OrasModel
public final class LayoutRef
extends Ref<LayoutRef> {
    private final Path folder;
    private static final Pattern NAME_REGEX = Pattern.compile("^(.+?)(?::([^:@]+))?(?:@(.+))?$");

    private LayoutRef(Path folder, @Nullable String tag) {
        super(tag);
        this.folder = folder;
    }

    public Path getFolder() {
        return this.folder;
    }

    public LayoutRef withTag(String tag) {
        return new LayoutRef(this.folder, tag);
    }

    @Override
    public LayoutRef withDigest(String digest) {
        return this.withTag(digest);
    }

    public static LayoutRef parse(String name) {
        Matcher matcher = NAME_REGEX.matcher(name);
        if (!matcher.matches()) {
            throw new OrasException("Invalid layout ref: " + name);
        }
        Path path = Path.of(matcher.group(1), new String[0]);
        String tag = matcher.group(2) != null ? matcher.group(2) : matcher.group(3);
        return new LayoutRef(path, tag);
    }

    public static LayoutRef of(OCILayout layout, String digest) {
        return new LayoutRef(layout.getPath(), digest);
    }

    public static LayoutRef of(OCILayout layout) {
        return new LayoutRef(layout.getPath(), null);
    }

    public LayoutRef forPath(Path path) {
        return new LayoutRef(path, this.tag);
    }

    public LayoutRef forLayout(OCILayout ociLayout) {
        return this.forPath(ociLayout.getPath());
    }

    @Override
    public SupportedAlgorithm getAlgorithm() {
        if (this.tag == null) {
            return SupportedAlgorithm.getDefault();
        }
        if (SupportedAlgorithm.isSupported(this.tag)) {
            return SupportedAlgorithm.fromDigest(this.tag);
        }
        return SupportedAlgorithm.getDefault();
    }

    public boolean isValidDigest() {
        if (this.tag == null) {
            return false;
        }
        return SupportedAlgorithm.isSupported(this.tag);
    }

    @Override
    public String getRepository() {
        return this.getFolder().toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayoutRef layoutRef = (LayoutRef)o;
        return Objects.equals(this.getFolder(), layoutRef.getFolder()) && Objects.equals(this.tag, layoutRef.tag);
    }

    public int hashCode() {
        return Objects.hash(this.getFolder(), this.tag);
    }

    public String toString() {
        if (this.tag != null) {
            if (this.isValidDigest()) {
                return "%s@%s".formatted(this.getFolder().toString(), this.tag);
            }
            return "%s:%s".formatted(this.getFolder().toString(), this.tag);
        }
        return this.getFolder().toString();
    }
}

