/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import land.oras.ContainerRef;
import land.oras.Descriptor;
import land.oras.OrasModel;
import land.oras.exception.OrasException;
import land.oras.utils.JsonUtils;
import land.oras.utils.SupportedAlgorithm;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@OrasModel
@JsonPropertyOrder(value={"mediaType", "digest", "size", "annotations", "data"})
public final class Layer
extends Descriptor {
    private final @Nullable String data;
    private final @Nullable Path blobPath;

    @JsonCreator
    private Layer(@JsonProperty(value="mediaType") String mediaType, @JsonProperty(value="digest") String digest, @JsonProperty(value="size") @Nullable Long size, @JsonProperty(value="data") @Nullable String data, @JsonProperty(value="annotations") @Nullable Map<String, String> annotations) {
        super(digest, size, mediaType, annotations, null, null);
        this.data = data;
        this.blobPath = null;
    }

    private Layer(String mediaType, String digest, long size, Path blobPath, Map<String, String> annotations) {
        super(digest, size, mediaType, annotations, null, null);
        this.data = null;
        this.blobPath = blobPath;
    }

    public @Nullable String getData() {
        return this.data;
    }

    @JsonIgnore
    public @Nullable Path getBlobPath() {
        return this.blobPath;
    }

    public Layer withAnnotations(Map<String, String> annotations) {
        return new Layer(this.mediaType, this.digest, this.size, this.data, annotations);
    }

    public Layer withMediaType(String mediaType) {
        return new Layer(mediaType, this.digest, this.size, this.data, (Map<String, String>)this.annotations);
    }

    @JsonIgnore
    public byte[] getDataBytes() {
        if (this.data != null) {
            return Base64.getDecoder().decode(this.data);
        }
        if (this.blobPath != null) {
            try {
                return Files.readAllBytes(this.blobPath);
            }
            catch (IOException e) {
                throw new OrasException("Failed to read layer data", e);
            }
        }
        throw new OrasException("No data or blob path set");
    }

    public static Layer fromJson(String json) {
        return JsonUtils.fromJson(json, Layer.class);
    }

    public static Layer fromFile(Path file) {
        return Layer.fromFile(file, SupportedAlgorithm.getDefault());
    }

    public static Layer fromFile(Path file, SupportedAlgorithm algorithm) {
        Map<String, String> annotations = Map.of("org.opencontainers.image.title", file.getFileName().toString());
        return new Layer("application/vnd.oci.image.layer.v1.tar", algorithm.digest(file), file.toFile().length(), file, annotations);
    }

    public static Layer fromData(ContainerRef containerRef, byte[] data) {
        return new Layer("application/vnd.oci.image.layer.v1.tar", containerRef.getAlgorithm().digest(data), Long.valueOf(data.length), Base64.getEncoder().encodeToString(data), Map.of());
    }

    public static Layer fromDigest(String digest, long size) {
        return new Layer("application/vnd.oci.empty.v1+json", digest, (Long)size, (String)null, Map.of());
    }

    public static Layer empty() {
        return new Layer("application/vnd.oci.empty.v1+json", "sha256:44136fa355b3678a1146ad16f7e8649e94fb4fc21fe77e8310c060f61caaff8a", (Long)2L, "e30=", Map.of());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Layer layer = (Layer)o;
        return Objects.equals(this.toJson(), layer.toJson());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

