/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import land.oras.Describable;
import land.oras.Descriptor;
import land.oras.ManifestDescriptor;
import land.oras.OrasModel;
import land.oras.Subject;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.Nullable;

@OrasModel
@JsonPropertyOrder(value={"schemaVersion", "mediaType", "artifactType", "digest", "size", "config", "subject", "annotations", "manifests"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Index
extends Descriptor
implements Describable {
    private final int schemaVersion;
    private final List<ManifestDescriptor> manifests;
    private final Subject subject;
    private final ManifestDescriptor descriptor;

    @JsonCreator
    private Index(@JsonProperty(value="schemaVersion") int schemaVersion, @JsonProperty(value="mediaType") String mediaType, @JsonProperty(value="artifactType") String artifactType, @JsonProperty(value="manifests") List<ManifestDescriptor> manifests, @JsonProperty(value="annotations") Map<String, String> annotations, @JsonProperty(value="subject") Subject subject) {
        this(schemaVersion, mediaType, artifactType, manifests, annotations, subject, null, null);
    }

    private Index(int schemaVersion, String mediaType, String artifactType, List<ManifestDescriptor> manifests, Map<String, String> annotations, Subject subject, ManifestDescriptor descriptor, String json) {
        super(null, null, mediaType, annotations, artifactType, json);
        this.schemaVersion = schemaVersion;
        this.descriptor = descriptor;
        this.subject = subject;
        this.manifests = manifests;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<ManifestDescriptor> getManifests() {
        return this.manifests;
    }

    @JsonProperty(value="artifactType")
    public String getArtifactTypeAsString() {
        return this.artifactType;
    }

    public Index withNewManifests(ManifestDescriptor manifest) {
        LinkedList<ManifestDescriptor> newManifests = new LinkedList<ManifestDescriptor>();
        for (ManifestDescriptor descriptor : this.manifests) {
            if (descriptor.getDigest().equals(manifest.getDigest())) continue;
            if (descriptor.getAnnotations() != null && descriptor.getAnnotations().containsKey("org.opencontainers.image.ref.name") && manifest.getAnnotations() != null && manifest.getAnnotations().containsKey("org.opencontainers.image.ref.name") && descriptor.getAnnotations().get("org.opencontainers.image.ref.name").equals(manifest.getAnnotations().get("org.opencontainers.image.ref.name"))) {
                LinkedHashMap<String, String> newAnnotations = new LinkedHashMap<String, String>(descriptor.getAnnotations());
                newAnnotations.remove("org.opencontainers.image.ref.name");
                if (newAnnotations.isEmpty()) {
                    newAnnotations = null;
                }
                newManifests.add(ManifestDescriptor.fromJson(descriptor.withAnnotations(newAnnotations).toJson()));
                continue;
            }
            newManifests.add(ManifestDescriptor.fromJson(descriptor.toJson()));
        }
        newManifests.add(manifest);
        return new Index(this.schemaVersion, this.mediaType, this.artifactType, newManifests, this.annotations, this.subject, this.descriptor, this.json);
    }

    @Override
    public ManifestDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @Nullable Map<String, String> getAnnotations() {
        if (this.annotations != null && !this.annotations.isEmpty()) {
            return this.annotations;
        }
        return null;
    }

    public Index withDescriptor(ManifestDescriptor descriptor) {
        return new Index(this.schemaVersion, this.mediaType, this.artifactType, this.manifests, this.annotations, this.subject, descriptor, this.json);
    }

    @Override
    protected Index withJson(String json) {
        this.json = json;
        return this;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public Index withSubject(Subject subject) {
        return new Index(this.schemaVersion, this.mediaType, this.artifactType, this.manifests, this.annotations, subject, this.descriptor, this.json);
    }

    public static Index fromJson(String json) {
        return JsonUtils.fromJson(json, Index.class).withJson(json);
    }

    public static Index fromPath(Path path) {
        return JsonUtils.fromJson(path, Index.class);
    }

    public static Index fromManifests(List<ManifestDescriptor> descriptors) {
        return new Index(2, "application/vnd.oci.image.index.v1+json", null, descriptors, null, null, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        return Objects.equals(this.toJson(), index.toJson());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

