/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import land.oras.Annotations;
import land.oras.Descriptor;
import land.oras.Layer;
import land.oras.OrasModel;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullUnmarked
@OrasModel
@JsonPropertyOrder(value={"mediaType", "digest", "size", "annotations", "data"})
public final class Config
extends Descriptor {
    private final @Nullable String data;

    @JsonCreator
    private Config(@JsonProperty(value="mediaType") String mediaType, @JsonProperty(value="digest") String digest, @JsonProperty(value="size") long size, @JsonProperty(value="data") @Nullable String data, @JsonProperty(value="annotations") @Nullable Map<String, String> annotations) {
        super(digest, size, mediaType, annotations != null && !annotations.isEmpty() ? Map.copyOf(annotations) : null, null, null);
        this.data = data;
    }

    private Config(String mediaType, String digest, long size, @Nullable String data, Annotations annotations) {
        super(digest, size, mediaType, !annotations.configAnnotations().isEmpty() ? Map.copyOf(annotations.configAnnotations()) : null, null, null);
        this.data = data;
    }

    @Override
    public @Nullable Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Config withAnnotations(Annotations annotations) {
        return new Config(this.mediaType, this.digest, (long)this.size, this.data, annotations);
    }

    public Config withMediaType(String mediaType) {
        return new Config(mediaType, this.digest, (long)this.size, this.data, this.annotations == null ? Annotations.empty() : Annotations.ofConfig(this.annotations));
    }

    @JsonIgnore
    public byte[] getDataBytes() {
        if (this.data != null) {
            return Base64.getDecoder().decode(this.data);
        }
        return "{}".getBytes(StandardCharsets.UTF_8);
    }

    public @Nullable String getData() {
        return this.data;
    }

    public static Config fromJson(String json) {
        return JsonUtils.fromJson(json, Config.class);
    }

    public static Config empty() {
        return new Config("application/vnd.oci.empty.v1+json", "sha256:44136fa355b3678a1146ad16f7e8649e94fb4fc21fe77e8310c060f61caaff8a", 2L, "e30=", Annotations.empty());
    }

    public static Config fromBlob(String mediaType, Layer layer) {
        return new Config(mediaType, layer.getDigest(), (long)layer.getSize(), null, Annotations.empty());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equals(this.toJson(), config.toJson());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.toJson());
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

