/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.util.Objects;
import land.oras.OrasModel;
import land.oras.exception.OrasException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@OrasModel
public class ArtifactType {
    private final String mediaType;

    private ArtifactType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public static ArtifactType from(@Nullable String artifactType) {
        if (artifactType == null) {
            return ArtifactType.unknown();
        }
        if (!artifactType.matches("^[a-zA-Z0-9!#$&-^_]+/[a-zA-Z0-9!#$&-^_]+$")) {
            throw new OrasException("Invalid artifact type: %s".formatted(artifactType));
        }
        return new ArtifactType(artifactType);
    }

    public static ArtifactType unknown() {
        return new ArtifactType("application/vnd.unknown.artifact.v1");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactType that = (ArtifactType)o;
        return Objects.equals(this.getMediaType(), that.getMediaType());
    }

    public int hashCode() {
        return Objects.hashCode(this.getMediaType());
    }

    public String toString() {
        return this.mediaType;
    }
}

