/*
 * Decompiled with CFR 0.152.
 */
package land.oras.utils;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.regex.Pattern;
import land.oras.exception.OrasException;
import land.oras.utils.DigestUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public enum SupportedAlgorithm {
    SHA1("SHA-1", "sha1", 20),
    SHA256("SHA-256", "sha256", 32),
    SHA384("SHA-384", "sha384", 48),
    SHA512("SHA-512", "sha512", 64),
    BLAKE3("BLAKE3-256", "blake3", 32);

    private final String algorithm;
    private final String prefix;
    private final int size;
    private static final Pattern DIGEST_REGEX;

    private SupportedAlgorithm(String algorithm, String prefix, int size) {
        this.algorithm = algorithm;
        this.prefix = prefix;
        this.size = size;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getAlgorithmName() {
        return this.algorithm;
    }

    public int getSize() {
        return this.size;
    }

    public String digest(byte[] bytes) {
        return DigestUtils.digest(this.algorithm, this.prefix, bytes);
    }

    public String digest(Path file) {
        return DigestUtils.digest(this.algorithm, this.prefix, file);
    }

    public String digest(InputStream inputStream) {
        return DigestUtils.digest(this.algorithm, this.prefix, inputStream);
    }

    static boolean matchPattern(String digest) {
        return DIGEST_REGEX.matcher(digest).matches();
    }

    public static boolean isSupported(String digest) {
        if (!SupportedAlgorithm.matchPattern(digest)) {
            return false;
        }
        for (SupportedAlgorithm algorithm : SupportedAlgorithm.values()) {
            if (!digest.startsWith(algorithm.getPrefix())) continue;
            String value = digest.substring(algorithm.getPrefix().length() + 1);
            if (value.length() != algorithm.getSize() * 2) {
                throw new OrasException("Invalid digest %s, expected size is %d, but got %d".formatted(digest, algorithm.getSize(), value.length()));
            }
            return true;
        }
        return false;
    }

    public static SupportedAlgorithm fromDigest(@Nullable String digest) {
        if (digest == null) {
            throw new OrasException("Digest is null");
        }
        if (!DIGEST_REGEX.matcher(digest).matches()) {
            throw new OrasException("Invalid digest: " + digest);
        }
        for (SupportedAlgorithm algorithm : SupportedAlgorithm.values()) {
            if (!digest.startsWith(algorithm.getPrefix())) continue;
            return algorithm;
        }
        throw new OrasException("Unsupported digest: " + digest);
    }

    public static SupportedAlgorithm getDefault() {
        return SHA256;
    }

    public static String getDigest(String digest) {
        SupportedAlgorithm algorithm = SupportedAlgorithm.fromDigest(digest);
        return digest.substring(algorithm.getPrefix().length() + 1);
    }

    static {
        DIGEST_REGEX = Pattern.compile("^[a-z0-9]+(?:[+._-][a-z0-9]+)*:[a-zA-Z0-9=_-]+$");
    }
}

