/*
 * Decompiled with CFR 0.152.
 */
package land.oras.utils;

import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.HexFormat;
import land.oras.exception.OrasException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class DigestUtils {
    private static final HexFormat HEX_FORMAT = HexFormat.of();

    private DigestUtils() {
    }

    static String digest(String algorithm, String prefix, Path path) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
                int chunkSize;
                long fileSize = channel.size();
                for (long position = 0L; position < fileSize; position += (long)chunkSize) {
                    long remaining = fileSize - position;
                    chunkSize = (int)Math.min(Integer.MAX_VALUE, remaining);
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, position, chunkSize);
                    digest.update(buffer);
                }
            }
            byte[] hashBytes = digest.digest();
            return DigestUtils.formatHex(prefix, hashBytes);
        }
        catch (Exception e) {
            throw new OrasException("Failed to calculate digest", e);
        }
    }

    static String digest(String algorithm, String prefix, byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashBytes = digest.digest(bytes);
            return DigestUtils.formatHex(prefix, hashBytes);
        }
        catch (Exception e) {
            throw new OrasException("Failed to calculate digest", e);
        }
    }

    static String digest(String algorithm, String prefix, InputStream input) {
        try {
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[8192];
            while ((bytesRead = input.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
            byte[] hashBytes = digest.digest();
            return DigestUtils.formatHex(prefix, hashBytes);
        }
        catch (Exception e) {
            throw new OrasException("Failed to calculate digest", e);
        }
    }

    private static String formatHex(String prefix, byte[] hashBytes) {
        String formatHex = HEX_FORMAT.formatHex(hashBytes);
        return prefix + ":" + formatHex;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

