/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import land.oras.ContainerRef;
import land.oras.auth.Scope;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ScopeUtils {
    ScopeUtils() {
    }

    public static List<String> appendRepositoryScope(@Nullable List<String> existingScopes, ContainerRef ref, Scope ... scope) {
        if (existingScopes == null) {
            existingScopes = new ArrayList<String>();
        }
        LinkedList<String> cleaned = new LinkedList<String>(ScopeUtils.cleanScopes(existingScopes));
        String repositoryScope = ScopeUtils.scopeRepository(ref, scope);
        if (!repositoryScope.isEmpty()) {
            cleaned.add(repositoryScope);
        }
        return ScopeUtils.cleanScopes(cleaned);
    }

    static String scopeRepository(ContainerRef ref, Scope ... scopes) {
        List<String> actions = Arrays.stream(scopes).map(Scope::toLowerCase).collect(Collectors.toList());
        List<String> cleaned = ScopeUtils.cleanActions(actions);
        String repository = ref.getFullRepository();
        if (cleaned.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)":", "repository", repository, String.join((CharSequence)",", cleaned));
    }

    static List<String> cleanScopes(@Nullable List<String> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return Collections.emptyList();
        }
        if (scopes.size() == 1) {
            String scope = scopes.get(0);
            int i = scope.lastIndexOf(58);
            if (i == -1) {
                return Collections.singletonList(scope);
            }
            List<String> actions = ScopeUtils.cleanActions(Arrays.asList(scope.substring(i + 1).split(",")));
            if (actions.isEmpty()) {
                return Collections.emptyList();
            }
            String string = scope.substring(0, i + 1) + String.join((CharSequence)",", actions);
            return Collections.singletonList(string);
        }
        HashMap<String, Map> resourceTypes = new HashMap<String, Map>();
        ArrayList<String> result = new ArrayList<String>();
        for (String string : scopes) {
            int firstColon = string.indexOf(58);
            if (firstColon == -1) {
                result.add(string);
                continue;
            }
            String resourceType = string.substring(0, firstColon);
            String rest = string.substring(firstColon + 1);
            int lastColon = rest.lastIndexOf(58);
            if (lastColon == -1) {
                result.add(string);
                continue;
            }
            String resourceName = rest.substring(0, lastColon);
            String actionPart = rest.substring(lastColon + 1);
            if (actionPart.isEmpty()) continue;
            Set actions = Arrays.stream(actionPart.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            resourceTypes.computeIfAbsent(resourceType, k -> new HashMap()).computeIfAbsent(resourceName, k -> new HashSet()).addAll(actions);
        }
        for (Map.Entry entry : resourceTypes.entrySet()) {
            String resourceType = (String)entry.getKey();
            for (Map.Entry nameEntry : ((Map)entry.getValue()).entrySet()) {
                String resourceName = (String)nameEntry.getKey();
                Set actionSet = (Set)nameEntry.getValue();
                if (actionSet.isEmpty()) continue;
                List<Object> actions = new ArrayList(actionSet);
                if (actions.contains("*")) {
                    actions = Collections.singletonList("*");
                } else {
                    Collections.sort(actions);
                }
                result.add(resourceType + ":" + resourceName + ":" + String.join((CharSequence)",", actions));
            }
        }
        Collections.sort(result);
        return result;
    }

    static List<String> cleanActions(@Nullable List<String> actions) {
        if (actions == null || actions.isEmpty()) {
            return Collections.emptyList();
        }
        if (actions.size() == 1) {
            return actions.get(0).isEmpty() ? Collections.emptyList() : actions;
        }
        ArrayList<String> sorted = new ArrayList<String>(actions);
        Collections.sort(sorted);
        ArrayList<String> result = new ArrayList<String>();
        String prev = null;
        for (String action : sorted) {
            if ("*".equals(action)) {
                return Collections.singletonList("*");
            }
            if (action.equals(prev)) continue;
            result.add(action);
            prev = action;
        }
        if (!result.isEmpty() && ((String)result.get(0)).isEmpty()) {
            return result.size() == 1 ? Collections.emptyList() : result.subList(1, result.size());
        }
        return result;
    }
}

