/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import java.util.Base64;
import land.oras.ContainerRef;
import land.oras.auth.AuthProvider;
import land.oras.auth.AuthScheme;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractUsernamePasswordProvider
implements AuthProvider {
    private final String username;
    private final String password;

    public AbstractUsernamePasswordProvider(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public @NonNull String getAuthHeader(ContainerRef registry) {
        return "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes());
    }

    @Override
    public AuthScheme getAuthScheme() {
        return AuthScheme.BASIC;
    }
}

