/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class LocalPath {
    private final @Nullable String mediaType;
    private final Path path;

    private LocalPath(@Nullable String mediaType, Path path) {
        this.mediaType = mediaType;
        this.path = path;
    }

    public static LocalPath of(Path path) {
        return new LocalPath(null, path);
    }

    public static LocalPath of(Path path, String mediaType) {
        return new LocalPath(mediaType, path);
    }

    public static LocalPath of(String expression) {
        int index = expression.lastIndexOf(58);
        if (index == -1) {
            return new LocalPath(null, Path.of(expression, new String[0]));
        }
        return new LocalPath(expression.substring(index + 1), Path.of(expression.substring(0, index), new String[0]));
    }

    public String getMediaType() {
        return this.mediaType != null ? this.mediaType : (Files.isDirectory(this.path, new LinkOption[0]) ? "application/vnd.oci.image.layer.v1.tar+gzip" : "application/vnd.oci.image.layer.v1.tar");
    }

    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }
}

