/*
 * Decompiled with CFR 0.152.
 */
package land.oras.utils;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;
import land.oras.LocalPath;
import land.oras.exception.OrasException;
import land.oras.utils.ArchiveUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public enum SupportedCompression {
    NO_COMPRESSION("application/vnd.oci.image.layer.v1.tar", localPath -> localPath, is -> {
        try {
            Path temp = ArchiveUtils.createTempTar();
            Files.copy(is, temp, StandardCopyOption.REPLACE_EXISTING);
            return LocalPath.of(temp, "application/vnd.oci.image.layer.v1.tar");
        }
        catch (Exception e) {
            throw new OrasException("Failed to copy stream to temporary file", e);
        }
    }),
    GZIP("application/vnd.oci.image.layer.v1.tar+gzip", ArchiveUtils::compressGzip, ArchiveUtils::uncompressGzip),
    ZSTD("application/vnd.oci.image.layer.v1.tar+zstd", ArchiveUtils::compressZstd, ArchiveUtils::uncompressZstd);

    private final String mediaType;
    private final Function<LocalPath, LocalPath> compressFunction;
    private final Function<InputStream, LocalPath> uncompressFunction;

    private SupportedCompression(String mediaType, Function<LocalPath, LocalPath> compressFunction, Function<InputStream, LocalPath> uncompressFunction) {
        this.mediaType = mediaType;
        this.compressFunction = compressFunction;
        this.uncompressFunction = uncompressFunction;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    LocalPath compress(LocalPath path) {
        if (!path.getMediaType().equals("application/vnd.oci.image.layer.v1.tar")) {
            throw new OrasException("Can only compress tar media type. Given " + path.getMediaType());
        }
        return this.compressFunction.apply(path);
    }

    LocalPath uncompress(InputStream inputStream) {
        return this.uncompressFunction.apply(inputStream);
    }

    static SupportedCompression fromMediaType(String mediaType) {
        for (SupportedCompression compression : SupportedCompression.values()) {
            if (!mediaType.equalsIgnoreCase(compression.getMediaType())) continue;
            return compression;
        }
        throw new OrasException("Unsupported mediaType: " + mediaType);
    }
}

