/*
 * Decompiled with CFR 0.152.
 */
package land.oras.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import land.oras.exception.OrasException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class JsonUtils {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeTypeAdapter()).disableHtmlEscaping().create();

    private JsonUtils() {
    }

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)gson.fromJson(json, clazz);
        }
        catch (JsonSyntaxException e) {
            throw new OrasException("Unable to parse JSON string", e);
        }
    }

    public static <T> T fromJson(Path path, Class<T> clazz) {
        try {
            return (T)gson.fromJson(Files.readString(path, StandardCharsets.UTF_8), clazz);
        }
        catch (IOException e) {
            throw new OrasException("Unable to read JSON file due to IO error", e);
        }
        catch (JsonSyntaxException e) {
            throw new OrasException("Unable to parse JSON file", e);
        }
    }

    public static <T> T fromJson(Path path, Type type) {
        try {
            return (T)gson.fromJson(Files.readString(path, StandardCharsets.UTF_8), type);
        }
        catch (IOException e) {
            throw new OrasException("Unable to read JSON file due to IO error", e);
        }
        catch (JsonSyntaxException e) {
            throw new OrasException("Unable to parse JSON file", e);
        }
    }

    public static <T> T fromJson(Reader reader, Type type) {
        try {
            return (T)gson.fromJson(reader, type);
        }
        catch (JsonSyntaxException e) {
            throw new OrasException("Unable to parse JSON content", e);
        }
    }

    public static String readFile(Path path) {
        try {
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new OrasException("Unable to read file", e);
        }
    }

    private static final class ZonedDateTimeTypeAdapter
    extends TypeAdapter<ZonedDateTime> {
        private ZonedDateTimeTypeAdapter() {
        }

        public void write(JsonWriter out, ZonedDateTime value) throws IOException {
            out.value(value.toString());
        }

        public ZonedDateTime read(JsonReader in) throws IOException {
            return ZonedDateTime.parse(in.nextString());
        }
    }
}

