/*
 * Decompiled with CFR 0.152.
 */
package land.oras.exception;

import land.oras.auth.HttpClient;
import land.oras.exception.Error;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class OrasException
extends RuntimeException {
    private static final Logger LOG = LoggerFactory.getLogger(OrasException.class);
    private @Nullable Error error;
    private @Nullable Integer statusCode;

    public OrasException(String message) {
        super(message);
    }

    public OrasException(HttpClient.ResponseWrapper<String> response) {
        this("Response code: " + response.statusCode());
        try {
            this.statusCode = response.statusCode();
            this.error = JsonUtils.fromJson(response.response(), Error.class);
        }
        catch (Exception e) {
            LOG.debug("Failed to parse error response", (Throwable)e);
        }
    }

    public OrasException(String message, Throwable cause) {
        super(message, cause);
    }

    public @Nullable Error getError() {
        return this.error;
    }

    public Integer getStatusCode() {
        if (this.statusCode == null) {
            return -1;
        }
        return this.statusCode;
    }
}

