/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import java.util.LinkedList;
import java.util.List;
import land.oras.ContainerRef;
import land.oras.Registry;
import land.oras.auth.Scope;
import land.oras.auth.ScopeUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Scopes {
    private final List<String> scopes;
    private final Registry registry;
    private final ContainerRef containerRef;

    private Scopes(Registry registry, ContainerRef containerRef, Scope ... scopes) {
        this(registry, containerRef, ScopeUtils.appendRepositoryScope(List.of(), containerRef, scopes));
    }

    private Scopes(Registry registry, ContainerRef containerRef, List<String> scopes) {
        this.registry = registry;
        this.containerRef = containerRef;
        this.scopes = scopes;
    }

    public static Scopes of(Registry registry, ContainerRef containerRef, Scope ... scopes) {
        return new Scopes(registry, containerRef, scopes);
    }

    public static Scopes empty(Registry registry, ContainerRef containerRef) {
        return new Scopes(registry, containerRef, List.of());
    }

    public Scopes withRegistryScopes(Scope ... scopes) {
        return new Scopes(this.registry, this.containerRef, scopes);
    }

    public Scopes withNewRegistryScopes(Scope ... newScopes) {
        return new Scopes(this.registry, this.containerRef, ScopeUtils.appendRepositoryScope(this.scopes, this.containerRef, newScopes));
    }

    public Scopes withNewScope(String scope) {
        LinkedList<String> newScopes = new LinkedList<String>(this.scopes);
        newScopes.add(scope);
        return new Scopes(this.registry, this.containerRef, ScopeUtils.cleanScopes(newScopes));
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getRegistry() {
        return this.containerRef.forRegistry(this.registry).getRegistry();
    }

    public ContainerRef getContainerRef() {
        return this.containerRef;
    }
}

