/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.util.Map;
import java.util.Objects;
import land.oras.Descriptor;
import land.oras.OrasModel;
import land.oras.Subject;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@OrasModel
public final class ManifestDescriptor {
    private final @Nullable String artifactType;
    private final String mediaType;
    private final String digest;
    private final long size;
    private final @Nullable Map<String, String> platform;
    private final @Nullable Map<String, String> annotations;

    private ManifestDescriptor(@Nullable String artifactType, String mediaType, String digest, long size, @Nullable Map<String, String> platform, @Nullable Map<String, String> annotations) {
        this.artifactType = artifactType;
        this.mediaType = mediaType;
        this.digest = digest;
        this.size = size;
        this.platform = platform;
        this.annotations = annotations;
    }

    public @Nullable String getArtifactType() {
        return this.artifactType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDigest() {
        return this.digest;
    }

    public long getSize() {
        return this.size;
    }

    public Map<String, String> getPlatform() {
        return this.platform;
    }

    public @Nullable Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }

    public static ManifestDescriptor fromJson(String json) {
        return JsonUtils.fromJson(json, ManifestDescriptor.class);
    }

    public Descriptor toDescriptor() {
        return Descriptor.of(this.digest, this.size, this.mediaType, this.annotations, this.artifactType);
    }

    public Subject toSubject() {
        return Subject.of(this.mediaType, this.digest, this.size);
    }

    public ManifestDescriptor withAnnotations(@Nullable Map<String, String> annotations) {
        return new ManifestDescriptor(this.artifactType, this.mediaType, this.digest, this.size, this.platform, annotations);
    }

    public ManifestDescriptor withArtifactType(@Nullable String artifactType) {
        return new ManifestDescriptor(artifactType, this.mediaType, this.digest, this.size, this.platform, this.annotations);
    }

    public static ManifestDescriptor of(String mediaType, String digest, long size) {
        return new ManifestDescriptor(null, mediaType, digest, size, null, null);
    }

    public static ManifestDescriptor of(Descriptor descriptor) {
        Objects.requireNonNull(descriptor.getDigest());
        Objects.requireNonNull(descriptor.getSize());
        return new ManifestDescriptor(descriptor.getArtifactType() != null ? descriptor.getArtifactType().getMediaType() : null, descriptor.getMediaType(), descriptor.getDigest(), descriptor.getSize(), null, descriptor.getAnnotations());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestDescriptor that = (ManifestDescriptor)o;
        return Objects.equals(this.toJson(), that.toJson());
    }

    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    public String toString() {
        return this.toJson();
    }
}

