/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import land.oras.ArtifactType;
import land.oras.OrasModel;
import land.oras.Subject;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@OrasModel
public class Descriptor {
    protected final String mediaType;
    protected final @Nullable Map<String, String> annotations;
    protected final @Nullable String digest;
    protected final @Nullable Long size;
    protected final @Nullable String artifactType;
    protected transient String json;

    protected Descriptor(String digest, Long size, String mediaType, Map<String, String> annotations, String artifactType, String json) {
        this.digest = digest;
        this.size = size;
        this.mediaType = mediaType;
        this.annotations = annotations;
        this.artifactType = artifactType;
        this.json = json;
    }

    public String getJson() {
        return this.json;
    }

    public Map<String, String> getAnnotations() {
        if (this.annotations == null) {
            return Map.of();
        }
        return Collections.unmodifiableMap(this.annotations);
    }

    public final String getMediaType() {
        return this.mediaType;
    }

    public @Nullable String getDigest() {
        return this.digest;
    }

    public @Nullable Long getSize() {
        return this.size;
    }

    public @Nullable ArtifactType getArtifactType() {
        if (this.artifactType != null) {
            return ArtifactType.from(this.artifactType);
        }
        return null;
    }

    public final String toJson() {
        return JsonUtils.toJson(this);
    }

    protected Descriptor withJson(String json) {
        this.json = json;
        return this;
    }

    public Subject toSubject() {
        Objects.requireNonNull(this.digest);
        Objects.requireNonNull(this.size);
        return Subject.of(this.mediaType, this.digest, this.size);
    }

    public static Descriptor of(String digest, Long size, String mediaType, Map<String, String> annotations, String artifactType) {
        return new Descriptor(digest, size, mediaType, annotations, artifactType, null);
    }

    public static Descriptor of(String digest, Long size, String mediaType) {
        return new Descriptor(digest, size, mediaType, null, null, null);
    }

    public static Descriptor of(String digest, Long size) {
        return new Descriptor(digest, size, "application/octet-stream", null, null, null);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return Objects.equals(this.toJson(), that.toJson());
    }

    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    public String toString() {
        return this.toJson();
    }
}

