/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.io.IOException;
import java.io.InputStream;
import land.oras.Descriptor;
import land.oras.Index;
import land.oras.Layer;
import land.oras.Manifest;
import land.oras.ManifestDescriptor;
import land.oras.OCI;
import land.oras.Ref;
import land.oras.Referrers;
import land.oras.exception.OrasException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(CopyUtils.class);

    private CopyUtils() {
    }

    public static <SourceRefType extends Ref<SourceRefType>, TargetRefType extends Ref<TargetRefType>> void copy(OCI<SourceRefType> source, SourceRefType sourceRef, OCI<TargetRefType> target, TargetRefType targetRef, boolean recursive) {
        block26: {
            try {
                String tag;
                InputStream is;
                Descriptor descriptor = source.probeDescriptor(sourceRef);
                String contentType = descriptor.getMediaType();
                String manifestDigest = descriptor.getDigest();
                LOG.debug("Content type: {}", (Object)contentType);
                LOG.debug("Manifest digest: {}", (Object)manifestDigest);
                for (Layer layer : source.collectLayers(sourceRef, contentType, true)) {
                    is = source.fetchBlob(sourceRef.withDigest(layer.getDigest()));
                    try {
                        target.pushBlob(targetRef.withDigest(layer.getDigest()), is);
                        LOG.debug("Copied layer {}", (Object)layer.getDigest());
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                if (source.isManifestMediaType(contentType)) {
                    Manifest manifest = source.getManifest(sourceRef);
                    tag = sourceRef.getTag();
                    is = source.pullConfig(sourceRef, manifest.getConfig());
                    try {
                        target.pushBlob(targetRef.withDigest(manifest.getConfig().getDigest()), is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    target.pushManifest(targetRef.withDigest(tag), manifest);
                    if (recursive) {
                        LOG.debug("Recursively copy referrers");
                        Referrers referrers = source.getReferrers(sourceRef.withDigest(manifestDigest), null);
                        for (ManifestDescriptor referer : referrers.getManifests()) {
                            LOG.info("Copy reference {}", (Object)referer.getDigest());
                            CopyUtils.copy(source, sourceRef.withDigest(referer.getDigest()), target, targetRef, recursive);
                        }
                    }
                    break block26;
                }
                if (source.isIndexMediaType(contentType)) {
                    Index index = source.getIndex(sourceRef);
                    tag = sourceRef.getTag();
                    target.pushIndex(targetRef.withDigest(tag), index);
                    for (ManifestDescriptor manifestDescriptor : index.getManifests()) {
                        Manifest manifest = source.getManifest(sourceRef.withDigest(manifestDescriptor.getDigest()));
                        try (InputStream is2 = source.pullConfig(sourceRef, manifest.getConfig());){
                            target.pushBlob(targetRef.withDigest(manifest.getConfig().getDigest()), is2);
                        }
                        target.pushManifest(targetRef.withDigest(manifest.getDigest()), manifest.withDescriptor(manifestDescriptor));
                    }
                    break block26;
                }
                throw new OrasException("Unsupported content type: %s".formatted(contentType));
            }
            catch (IOException e) {
                throw new OrasException("Failed to copy container", e);
            }
        }
    }
}

