/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import land.oras.ArtifactType;
import land.oras.OrasModel;
import land.oras.Ref;
import land.oras.Registry;
import land.oras.exception.OrasException;
import land.oras.utils.SupportedAlgorithm;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@OrasModel
public final class ContainerRef
extends Ref<ContainerRef> {
    private static final Pattern NAME_REGEX = Pattern.compile("(?:([^/@]+[.:][^/@]*)/)?((?:[^:@/]+/)+)?([^:@/]+)(?::([^:@]+))?(?:@(.+))?$");
    private final String registry;
    private final String repository;
    private final @Nullable String namespace;
    private final @Nullable String digest;
    private final boolean unqualified;

    private ContainerRef(String registry, boolean unqualified, @Nullable String namespace, String repository, String tag, @Nullable String digest) {
        super(tag);
        this.unqualified = unqualified;
        this.registry = registry;
        this.namespace = namespace;
        this.repository = repository;
        this.digest = digest;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getEffectiveRegistry(Registry target) {
        if (this.isUnqualified() && target.getRegistry() != null) {
            return target.getRegistry();
        }
        return this.registry;
    }

    public boolean isUnqualified() {
        return this.unqualified;
    }

    public String getFullRepository(@Nullable Registry registry) {
        String namespace = this.getNamespace(registry);
        if (namespace != null) {
            return "%s/%s".formatted(namespace, this.repository);
        }
        return this.repository;
    }

    public String getFullRepository() {
        return this.getFullRepository(null);
    }

    public String getApiRegistry(@Nullable Registry target) {
        String registry;
        String string = registry = target != null && target.getRegistry() != null ? target.getRegistry() : this.getRegistry();
        if (registry.equals("docker.io")) {
            return "registry-1.docker.io";
        }
        return registry;
    }

    public String getApiRegistry() {
        return this.getApiRegistry(null);
    }

    public @Nullable String getNamespace() {
        String registry = this.getRegistry();
        if (this.namespace == null && registry.equals("docker.io")) {
            return "library";
        }
        return this.namespace;
    }

    public @Nullable String getNamespace(@Nullable Registry target) {
        if (target == null || target.getRegistry() == null) {
            return this.getNamespace();
        }
        if (this.namespace == null && target.getRegistry().equals("docker.io")) {
            return "library";
        }
        return this.namespace;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    public @Nullable String getDigest() {
        return this.digest;
    }

    @Override
    public ContainerRef withDigest(String digest) {
        return new ContainerRef(this.registry, this.unqualified, this.namespace, this.repository, this.tag, digest);
    }

    @Override
    public SupportedAlgorithm getAlgorithm() {
        if (this.digest == null) {
            return SupportedAlgorithm.getDefault();
        }
        return SupportedAlgorithm.fromDigest(this.digest);
    }

    private String getApiPrefix(@Nullable Registry target) {
        String namespace = this.getNamespace(target);
        if (namespace != null) {
            return "%s/v2/%s/%s".formatted(this.getApiRegistry(target), namespace, this.repository);
        }
        return "%s/v2/%s".formatted(this.getApiRegistry(target), this.repository);
    }

    public String getRepositoriesPath(@Nullable Registry target) {
        return "%s/v2/_catalog".formatted(this.getApiRegistry(target));
    }

    public String getRepositoriesPath() {
        return this.getRepositoriesPath(null);
    }

    public String getTagsPath(@Nullable Registry target) {
        return "%s/tags/list".formatted(this.getApiPrefix(target));
    }

    public String getTagsPath() {
        return this.getTagsPath(null);
    }

    public String getReferrersPath(@Nullable Registry registry, @Nullable ArtifactType artifactType) {
        if (artifactType == null) {
            return "%s/referrers/%s".formatted(this.getApiPrefix(registry), this.digest);
        }
        return "%s/referrers/%s?artifactType=%s".formatted(this.getApiPrefix(registry), this.digest, URLEncoder.encode(artifactType.toString(), StandardCharsets.UTF_8));
    }

    public String getReferrersPath(@Nullable ArtifactType artifactType) {
        return this.getReferrersPath(null, artifactType);
    }

    public String getManifestsPath(@Nullable Registry registry) {
        return "%s/manifests/%s".formatted(this.getApiPrefix(registry), this.digest == null ? this.tag : this.digest);
    }

    public String getManifestsPath() {
        return this.getManifestsPath(null);
    }

    public String getBlobsUploadDigestPath(Registry registry) {
        if (this.digest == null) {
            throw new OrasException("You are required to include a digest");
        }
        return "%s/blobs/uploads/?digest=%s".formatted(this.getApiPrefix(registry), this.digest);
    }

    public String getBlobsPath(@Nullable Registry registry) {
        if (this.digest == null) {
            throw new OrasException("You are required to include a digest");
        }
        return "%s/blobs/%s".formatted(this.getApiPrefix(registry), this.digest);
    }

    public static ContainerRef parse(String name) {
        Matcher matcher = NAME_REGEX.matcher(name = name.replaceAll("^(http://|https://|oci://)", ""));
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid container name format");
        }
        String registry = matcher.group(1);
        String namespace = matcher.group(2);
        String repository = matcher.group(3);
        String tag = matcher.group(4);
        String digest = matcher.group(5);
        boolean unqualified = false;
        if (repository == null) {
            throw new IllegalArgumentException("You are minimally required to include a <namespace>/<repository>");
        }
        if (registry == null) {
            registry = "docker.io";
            unqualified = true;
        }
        if (tag == null) {
            tag = "latest";
        }
        if (namespace != null) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        if (digest != null) {
            SupportedAlgorithm.fromDigest(digest);
        }
        return new ContainerRef(registry, unqualified, namespace, repository, tag, digest);
    }

    public ContainerRef forRegistry(String registry) {
        return new ContainerRef(registry, false, this.namespace, this.repository, this.tag, this.digest);
    }

    public ContainerRef forRegistry(Registry registry) {
        return new ContainerRef(registry.getRegistry() != null ? registry.getRegistry() : this.registry, false, this.namespace, this.repository, this.tag, this.digest);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerRef that = (ContainerRef)o;
        return Objects.equals(this.getRegistry(), that.getRegistry()) && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getNamespace(), that.getNamespace()) && Objects.equals(this.getDigest(), that.getDigest()) && Objects.equals(this.getTag(), that.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistry(), this.getRepository(), this.getNamespace(), this.getDigest(), this.getTag());
    }

    public String toString() {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            return "%s/%s/%s:%s%s".formatted(this.registry, this.namespace, this.repository, this.tag, this.digest != null ? "@" + this.digest : "");
        }
        return "%s/%s:%s%s".formatted(this.registry, this.repository, this.tag, this.digest != null ? "@" + this.digest : "");
    }
}

